<?php

namespace Modules\City\Entities;

use Modules\Country\Entities\Country;
use Modules\Listing\Entities\Listing;
use Illuminate\Database\Eloquent\Model;
use Modules\City\Entities\CityTranslation;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class City extends Model
{
    use HasFactory;

    protected $fillable = [];

    protected $appends = ['name', 'total_classified_listing', 'total_jobpost_listing', 'total_realestate_listing', 'total_listing'];

    protected $hidden = ['front_translate'];

    protected static function newFactory()
    {
        return \Modules\City\Database\factories\CityFactory::new();
    }


    public function country(){
        return $this->belongsTo(Country::class);
    }

    public function translate(){
        return $this->belongsTo(CityTranslation::class, 'id', 'city_id')->where('lang_code', admin_lang());
    }

    public function front_translate(){
        return $this->belongsTo(CityTranslation::class, 'id', 'city_id')->where('lang_code', front_lang());
    }

    public function getNameAttribute()
    {
        return $this->front_translate->name;
    }

    public function listings($type = null){
        if($type == null){
            return $this->hasMany(Listing::class, 'city_id')->where(function ($query) {
                $query->where('expired_date', null)
                    ->orWhere('expired_date', '>=', date('Y-m-d'));
            })->where(['status' => 'enable', 'approved_by_admin' => 'approved']);
        }else{
            return $this->hasMany(Listing::class, 'city_id')->where(function ($query) {
                $query->where('expired_date', null)
                    ->orWhere('expired_date', '>=', date('Y-m-d'));
            })->where(['status' => 'enable', 'approved_by_admin' => 'approved', 'category_id' => $type]);
        }

    }

    public function getTotalClassifiedListingAttribute()
    {
        return $this->listings(1)->count();
    }

    public function getTotalJobpostListingAttribute()
    {
        return $this->listings(3)->count();
    }

    public function getTotalRealestateListingAttribute()
    {
        return $this->listings(2)->count();
    }

    public function getTotalListingAttribute()
    {
        return $this->listings()->count();
    }






}
