<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use App\Models\Review;
use App\Models\Wishlist;
use App\Models\JobRequest;
use App\Helpers\MailHelper;
use Illuminate\Http\Request;

use App\Models\ListingReport;
use App\Http\Controllers\Controller;
use Modules\Listing\Entities\Listing;
use Auth, Str, Image, File, Hash, Mail;

use Modules\Kyc\Entities\KycInformation;
use Modules\GeneralSetting\Entities\EmailTemplate;
use Modules\Subscription\Entities\SubscriptionHistory;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function user_list(){

        $users = User::where('status', 'enable')->latest()->get();

        $title = trans('translate.User List');

        return view('admin.user.user_list', ['users' => $users, 'title' => $title]);
    }

    public function pending_user(){

        $users = User::where('status', 'disable')->latest()->get();

        $title = trans('translate.Pending User');

        return view('admin.user.user_list', ['users' => $users, 'title' => $title]);
    }

    public function user_show($id){

        $user = User::findOrFail($id);

        $total_classified = Listing::where('agent_id', $user->id)->where('category_id', 1)->count();
        $total_realestate = Listing::where('agent_id', $user->id)->where('category_id', 2)->count();
        $total_jobpost = Listing::where('agent_id', $user->id)->where('category_id', 3)->count();

        $total_listing = Listing::where('agent_id', $user->id)->count();

        $total_purchase = SubscriptionHistory::whereDate('user_id', $id)->sum('plan_price');

        $total_purchase = SubscriptionHistory::whereDate('user_id', $id)->sum('plan_price');

        $total_job_request = JobRequest::where('user_id', $user->id)->count();

        $total_hired = JobRequest::where('agent_id', $user->id)->where('status', 'approved')->count();

        $listings = Listing::with('translate','agent','category')->where('agent_id', $user->id)->latest()->get();

        return view('admin.user.user_show', [
            'user' => $user,
            'total_classified' => $total_classified,
            'total_realestate' => $total_realestate,
            'total_jobpost' => $total_jobpost,
            'total_listing' => $total_listing,
            'total_purchase' => $total_purchase,
            'total_job_request' => $total_job_request,
            'total_hired' => $total_hired,
            'listings' => $listings,
        ]);
    }

    public function update(Request $request ,$id){

        $user = User::findOrFail($id);

        $rules = [
            'name'=>'required',
            'phone'=>'required',
            'address'=>'required|max:220',
        ];
        $customMessages = [
            'name.required' => trans('translate.Name is required'),
            'phone.required' => trans('translate.Phone is required'),
            'address.required' => trans('translate.Address is required')
        ];
        $this->validate($request, $rules,$customMessages);

        $user->name = $request->name;
        $user->phone = $request->phone;
        $user->whatsapp_phone = $request->whatsapp_phone;
        $user->address = $request->address;
        $user->designation = $request->designation;
        $user->about_me = $request->about_me;
        $user->status = $request->status ? 'enable' : 'disable';
        $user->save();

        $notification= trans('translate.User updated successful');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function user_destroy($id){

        $total_listing = Listing::where('agent_id', $id)->count();
        if($total_listing > 0){
            $notification = trans('translate.You can not delete this user, multiple listing available under this user');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->route('admin.user-list')->with($notification);
        }

        $user = User::find($id);
        $user_image = $user->image;

        if($user_image){
            if(File::exists(public_path().'/'.$user_image))unlink(public_path().'/'.$user_image);
        }

        Review::where('user_id',$id)->delete();
        SubscriptionHistory::where('user_id',$id)->delete();
        Wishlist::where('user_id',$id)->delete();
        JobRequest::where('user_id',$id)->delete();
        JobRequest::where('agent_id',$id)->delete();
        ListingReport::where('agent_id',$id)->delete();

        $kyc = KycInformation::where(['user_id' => $id])->first();

        if($kyc){
            $kyc_file = $kyc->file;
            if($kyc_file){
                if(File::exists(public_path().'/'.$kyc_file))unlink(public_path().'/'.$kyc_file);
            }
        }

        $user->delete();

        $notification = trans('translate.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.user-list')->with($notification);

    }

    public function user_status($id){
        $user = User::findOrFail($id);
        if($user->status == 'enable'){
            $user->status = 'disable';
            $user->save();
            $message = trans('translate.Status Changed Successfully');
        }else{
            $user->status = 'enable';
            $user->save();
            $message = trans('translate.Status Changed Successfully');
        }
        return response()->json($message);
    }


}
