@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ asset($breadcrumb) }});">
        <div class="container">
            <div class="row">
                <div class="  col-xxl-3  col-xl-5 col-lg-5">

                    @php
                        $title = '';
                        if(request()->get('category') == 'jobpost'){
                            $title = trans('translate.Job Post');
                        }elseif (request()->get('category') == 'classified') {
                            $title = trans('translate.Classified Listing');
                        }elseif (request()->get('category') == 'realestate') {
                            $title = trans('translate.Real Estate Listing');
                        }
                    @endphp
                    <div class="inner-bg-txt">
                        <h1>{{ $title }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ $title }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->



    <!-- Classified Listingspart start  -->

    <section class="classified-listings footer-top-pad">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-xl-3 ">
                    <form action="{{ route('listings') }}" id="listing_filter_form">
                        <input type="hidden" value="{{ request()->get('category') }}" name="category">
                    <div class="side-filter">
                        <h4 class="side-filter-taitel">
                            {{ __('translate.Keyword') }}
                        </h4>
                        <div class="search-box">
                            <input type="text" class="form-control"
                                placeholder="{{ __('translate.Type keyword') }}" name="keyword" value="{{ request()->get('keyword') }}">

                            <button class="sarch-btn" type="submit">
                                <span>
                                    <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M14.125 12.0307L15.5663 13.4719C16.1446 14.0503 16.1446 14.9879 15.5663 15.5663C14.9879 16.1446 14.0503 16.1446 13.4719 15.5663L12.0307 14.125M1 7.375C1 3.85418 3.85418 1 7.37499 1C10.8958 1 13.75 3.85418 13.75 7.375C13.75 10.8958 10.8958 13.75 7.37499 13.75C3.85418 13.75 1 10.8958 1 7.375Z"
                                            stroke-width="1.2" stroke-linecap="round"></path>
                                    </svg>
                                </span>
                            </button>
                        </div>

                        <h4 class="side-filter-taitel mt-3">
                            {{ __('translate.Country') }}
                        </h4>
                        <div class="search-box search-box2">
                            <select class="form-select select2" name="country" id="country_id">
                                <option value="">{{ __('translate.Select') }}</option>
                                @foreach ($countries as $country)
                                <option {{ request()->get('country') == $country->id ? 'selected' : '' }} value="{{ $country->id }}">{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <h4 class="side-filter-taitel mt-3">
                            {{ __('translate.City or Location') }}
                        </h4>
                        <div class="search-box search-box2">
                            <select class="form-select select2" name="location" id="city_id">
                                <option value="">{{ __('translate.Select') }}</option>
                                @foreach ($cities as $city)
                                <option {{ request()->get('location') == $city->id ? 'selected' : '' }} value="{{ $city->id }}">{{ $city->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <h4 class="side-filter-taitel mt-3">
                            {{ __('translate.Categories') }}
                        </h4>
                        <div class="search-box search-box2">
                            <select class="form-select select2" name="sub_category_id" id="sub_category_id">
                                <option value="">{{ __('translate.Select') }}</option>
                                @foreach ($sub_categories as $sub_category)
                                <option {{ request()->get('sub_category_id') == $sub_category->id ? 'selected' : '' }} value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <h4 class="side-filter-taitel mt-3">
                            {{ __('translate.Sub Categories') }}
                        </h4>
                        <div class="search-box search-box2">
                            <select class="form-select select2" name="child_category_id" id="child_category_id">
                                <option value="">{{ __('translate.Select') }}</option>
                                @foreach ($child_categories as $child_category)
                                <option {{ request()->get('child_category_id') == $child_category->id ? 'selected' : '' }} value="{{ $child_category->id }}">{{ $child_category->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="accordion" id="accordionPanelsStayOpenExample3">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="panelsStayOpen-headingthree">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#panelsStayOpen-collapsethree" aria-expanded="true"
                                        aria-controls="panelsStayOpen-collapsethree">
                                        {{ __('translate.Aminities or Features') }}
                                    </button>
                                </h2>
                                <div id="panelsStayOpen-collapsethree" class="accordion-collapse collapse show"
                                    aria-labelledby="panelsStayOpen-headingthree">
                                    <div class="accordion-body">
                                        <ul class="categories-item two">

                                            @if (request()->has('aminities'))
                                                @php
                                                    $aminity_arr = request()->get('aminities');
                                                @endphp

                                                @foreach ($aminities as $index => $aminity)
                                                    <li>
                                                        <div class="form-check">
                                                            <input {{ in_array($aminity->id, $aminity_arr) ? 'checked' : '' }} class="form-check-input" type="checkbox" value="{{ $aminity->id }}"
                                                                id="aminity_{{ $aminity->id }}" name="aminities[]">
                                                            <label class="form-check-label" for="aminity_{{ $aminity->id }}">
                                                                {{ $aminity->name }}
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            @else
                                                @foreach ($aminities as $index => $aminity)
                                                    <li>
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="checkbox" value="{{ $aminity->id }}"
                                                                id="aminity_{{ $aminity->id }}" name="aminities[]">
                                                            <label class="form-check-label" for="aminity_{{ $aminity->id }}">
                                                                {{ $aminity->name }}
                                                            </label>
                                                        </div>
                                                    </li>
                                                @endforeach

                                            @endif

                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="accordion" id="accordionPanelsStayOpenExample4">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="panelsStayOpen-headingfour">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#panelsStayOpen-collapsefour" aria-expanded="true"
                                        aria-controls="panelsStayOpen-collapsefour">
                                        {{ __('translate.Price') }}
                                    </button>
                                </h2>
                                <div id="panelsStayOpen-collapsefour" class="accordion-collapse collapse show"
                                    aria-labelledby="panelsStayOpen-headingfour">
                                    <div class="accordion-body">
                                        <span class="price">
                                            <span class="range-slider style-1">
                                                <span id="slider-tooltips"
                                                    class="slider-range mb-3 noUi-target noUi-ltr noUi-horizontal noUi-txt-dir-ltr">

                                                </span>
                                                <span class="example-val" id="slider-margin-value-min">{{ __('translate.Range') }}:
                                                    {{ currency(0) }}</span>
                                                <span>-</span>
                                                <span class="example-val" id="slider-margin-value-max">{{ currency($max_price) }}</span>
                                            </span>
                                        </span>
                                        <input type="hidden" id="min_price" name="min_price" value="0">
                                        <input type="hidden" id="max_price" name="max_price" value="{{ currency($max_price) }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <a class="main-btn " href="javascript:;" id="listing_filter_btn">
                            <div class="btn_m">
                                <div class="btn_c">
                                    <div class="btn_t1">{{ __('translate.Search') }}</div>
                                    <div class="btn_t2">{{ __('translate.Search') }}</div>
                                </div>
                            </div>
                        </a>

                    </div>


                </form>

                    @if ($listing_ads->status == 'enable')
                        <div class="classified-listings-ads">
                            <a href="{{ $listing_ads->link }}" target="_blank">
                                <img src="{{ asset($listing_ads->image) }}" alt="img">
                            </a>
                        </div>
                    @endif


                </div>

                <div class="col-lg-8 col-xl-9">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="classified-listings-bar">
                                <div class="left">
                                    <h4 class="left-txt"><span>{{ $listings->count() }} {{ __('translate.Results') }}</span> {{ $title }}</h4>
                                </div>

                                <div class="right">

                                    <div class="right-item-btn">
                                        <ul class="nav nav-pills " id="pills-tab" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="pills-home-tab"
                                                    data-bs-toggle="pill" data-bs-target="#pills-home" type="button"
                                                    role="tab" aria-controls="pills-home" aria-selected="true">

                                                    <span>
                                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M6.88404 0.222168H2.58645C1.28267 0.222168 0.22168 1.28316 0.22168 2.58694V6.884C0.22168 8.18778 1.28267 9.24877 2.58645 9.24877H6.88351C8.18729 9.24877 9.24828 8.18778 9.24828 6.884V2.58694C9.24881 1.28316 8.18781 0.222168 6.88404 0.222168ZM7.67229 6.88452C7.67229 7.31912 7.31863 7.67278 6.88404 7.67278H2.58645C2.15186 7.67278 1.7982 7.31912 1.7982 6.88452V2.58747C1.7982 2.15287 2.15186 1.79921 2.58645 1.79921H6.88351C7.3181 1.79921 7.67177 2.15287 7.67177 2.58747L7.67229 6.88452ZM17.5161 0.222168H13.2185C11.9147 0.222168 10.8537 1.28316 10.8537 2.58694V6.884C10.8537 8.18778 11.9147 9.24877 13.2185 9.24877H17.5161C18.8198 9.24877 19.8808 8.18778 19.8808 6.884V2.58694C19.8808 1.28316 18.8204 0.222168 17.5161 0.222168ZM18.3043 6.88452C18.3043 7.31912 17.9507 7.67278 17.5161 7.67278H13.2185C12.7839 7.67278 12.4302 7.31912 12.4302 6.88452V2.58747C12.4302 2.15287 12.7839 1.79921 13.2185 1.79921H17.5161C17.9507 1.79921 18.3043 2.15287 18.3043 2.58747V6.88452ZM6.88404 10.3481H2.58645C1.28267 10.3481 0.22168 11.4091 0.22168 12.7129V17.01C0.22168 18.3137 1.28267 19.3747 2.58645 19.3747H6.88351C8.18729 19.3747 9.24828 18.3137 9.24828 17.01V12.7129C9.24881 11.4086 8.18781 10.3481 6.88404 10.3481ZM7.67229 17.01C7.67229 17.4446 7.31863 17.7982 6.88404 17.7982H2.58645C2.15186 17.7982 1.7982 17.4446 1.7982 17.01V12.7129C1.7982 12.2783 2.15186 11.9246 2.58645 11.9246H6.88351C7.3181 11.9246 7.67177 12.2783 7.67177 12.7129L7.67229 17.01ZM17.5161 10.3481H13.2185C11.9147 10.3481 10.8537 11.4091 10.8537 12.7129V17.01C10.8537 18.3137 11.9147 19.3747 13.2185 19.3747H16.4293C16.8644 19.3747 17.2176 19.0216 17.2176 18.5865C17.2176 18.1514 16.8644 17.7982 16.4293 17.7982H13.2185C12.7839 17.7982 12.4302 17.4446 12.4302 17.01V12.7129C12.4302 12.2783 12.7839 11.9246 13.2185 11.9246H17.5161C17.9507 11.9246 18.3043 12.2783 18.3043 12.7129V16.3147C18.3043 16.7498 18.6575 17.103 19.0926 17.103C19.5277 17.103 19.8808 16.7498 19.8808 16.3147V12.7129C19.8808 11.4086 18.8204 10.3481 17.5161 10.3481Z" />
                                                        </svg>

                                                    </span>


                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="pills-profile-tab"
                                                    data-bs-toggle="pill" data-bs-target="#pills-profile"
                                                    type="button" role="tab" aria-controls="pills-profile"
                                                    aria-selected="false">

                                                    <span>
                                                        <svg width="27" height="19" viewBox="0 0 27 19" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M23.3586 0.516113H6.84208C5.9299 0.516113 5.19043 1.25559 5.19043 2.16776C5.19043 3.07994 5.9299 3.81942 6.84208 3.81942H23.3586C24.2708 3.81942 25.0102 3.07994 25.0102 2.16776C25.0102 1.25559 24.2708 0.516113 23.3586 0.516113Z"
                                                                fill="white" />
                                                            <path
                                                                d="M3.53814 2.16789C3.53628 1.73056 3.36105 1.31182 3.0509 1.00348C2.40671 0.363099 1.36627 0.363099 0.722075 1.00348C0.411874 1.31182 0.236644 1.73056 0.234838 2.16789C0.222502 2.27489 0.222502 2.38297 0.234838 2.48996C0.253522 2.59758 0.283974 2.70282 0.325679 2.80378C0.370015 2.90158 0.422507 2.99552 0.482585 3.08456C0.54189 3.17715 0.611105 3.26299 0.689042 3.34056C0.764192 3.4154 0.847239 3.48188 0.93679 3.53876C1.02376 3.60209 1.11806 3.65479 1.21757 3.69567C1.32704 3.75244 1.44374 3.79415 1.56442 3.81954C1.67141 3.83152 1.77949 3.83152 1.88649 3.81954C2.32263 3.8199 2.74122 3.64772 3.0509 3.34056C3.12884 3.26299 3.19806 3.17715 3.25736 3.08456C3.31744 2.99552 3.36993 2.90158 3.41427 2.80378C3.46696 2.70406 3.50851 2.59882 3.53814 2.48996C3.55048 2.38297 3.55048 2.27489 3.53814 2.16789Z"
                                                                fill="white" />
                                                            <path
                                                                d="M3.53865 9.60026C3.55094 9.49327 3.55094 9.38519 3.53865 9.27819C3.51011 9.17161 3.46851 9.069 3.41478 8.97264C3.37225 8.87132 3.31966 8.77449 3.25787 8.6836C3.20063 8.59203 3.13116 8.50868 3.05142 8.43585C2.40722 7.79547 1.36678 7.79547 0.722589 8.43585C0.412388 8.74419 0.237158 9.16294 0.235352 9.60026C0.238552 9.81792 0.280514 10.0332 0.359225 10.2361C0.40062 10.3339 0.450376 10.4278 0.507874 10.5169C0.570688 10.6067 0.642638 10.6897 0.722589 10.7647C0.795571 10.8443 0.878876 10.9137 0.970336 10.9711C1.05731 11.0345 1.15155 11.0872 1.25112 11.128C1.35182 11.1704 1.45716 11.2009 1.56493 11.2189C1.67059 11.2426 1.77872 11.2537 1.887 11.2519C1.994 11.2643 2.10208 11.2643 2.20907 11.2519C2.31416 11.2339 2.41677 11.2034 2.51463 11.1611C2.61688 11.1205 2.71391 11.0678 2.80367 11.0042C2.89513 10.9468 2.97843 10.8773 3.05142 10.7977C3.13101 10.7247 3.20048 10.6414 3.25787 10.55C3.32136 10.463 3.37406 10.3688 3.41478 10.2692C3.47119 10.1596 3.51285 10.0429 3.53865 9.92233C3.55135 9.81534 3.55135 9.70726 3.53865 9.60026Z"
                                                                fill="white" />
                                                            <path
                                                                d="M3.53876 17.0326C3.55099 16.9256 3.55099 16.8176 3.53876 16.7106C3.51021 16.6013 3.46861 16.496 3.41488 16.3967C3.37055 16.2989 3.31805 16.205 3.25798 16.116C3.20058 16.0245 3.13111 15.9412 3.05152 15.8682C2.40732 15.2278 1.36689 15.2278 0.72269 15.8682C0.643101 15.9412 0.573628 16.0245 0.516234 16.116C0.456155 16.205 0.403663 16.2989 0.359327 16.3967C0.316487 16.4973 0.285983 16.6027 0.268486 16.7106C0.245208 16.8163 0.234162 16.9243 0.235453 17.0326C0.237311 17.47 0.412541 17.8887 0.72269 18.197C0.795672 18.2766 0.878978 18.3461 0.970438 18.4035C1.05741 18.4669 1.15165 18.5196 1.25122 18.5604C1.35192 18.6028 1.45726 18.6333 1.56503 18.6513C1.67069 18.6749 1.77882 18.686 1.8871 18.6843C1.9941 18.6966 2.10218 18.6966 2.20918 18.6843C2.31426 18.6663 2.41687 18.6358 2.51473 18.5934C2.61698 18.5529 2.71401 18.5002 2.80377 18.4365C2.89523 18.3791 2.97854 18.3097 3.05152 18.2301C3.13111 18.1571 3.20058 18.0738 3.25798 17.9823C3.32151 17.8955 3.37421 17.8012 3.41488 17.7016C3.47124 17.5919 3.5129 17.4753 3.53876 17.3547C3.55145 17.2477 3.55145 17.1396 3.53876 17.0326Z"
                                                                fill="white" />
                                                            <path
                                                                d="M25.0102 7.94849H6.84208C5.9299 7.94849 5.19043 8.68796 5.19043 9.60014C5.19043 10.5123 5.9299 11.2518 6.84208 11.2518H25.0102C25.9224 11.2518 26.6619 10.5123 26.6619 9.60014C26.6619 8.68796 25.9224 7.94849 25.0102 7.94849Z"
                                                                fill="white" />
                                                            <path
                                                                d="M17.5778 15.3811H6.84208C5.9299 15.3811 5.19043 16.1206 5.19043 17.0328C5.19043 17.9449 5.9299 18.6844 6.84208 18.6844H17.5778C18.49 18.6844 19.2295 17.9449 19.2295 17.0328C19.2295 16.1206 18.49 15.3811 17.5778 15.3811Z"
                                                                fill="white" />
                                                        </svg>

                                                    </span>
                                                </button>
                                            </li>
                                        </ul>
                                    </div>



                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-lg-12">

                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                    aria-labelledby="pills-home-tab">
                                    <div class="row mt-20px g-3 {{ request()->get('category') == 'jobpost' ? 'job-listing common-class' : '' }}">
                                        @forelse ($listings as $index => $listing)
                                            @if ($listing->category_id == 3)
                                                <div class="col-xxl-4 col-lg-6 col-sm-6" @if ($index > 2)  data-aos="fade-up" @endif>
                                                    <div class="job-listing-item">
                                                        <div class="job-listing-item-inner">
                                                            <div class="job-listing-img">
                                                                <img src="{{ asset($listing->thumb_image) }}" alt="img">
                                                            </div>

                                                            <div class="job-listing-img-btn">
                                                                @guest('web')
                                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                @else
                                                                    <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                @endguest

                                                                @if ($listing->is_urgent == 'enable')
                                                                    <span class="txt">{{ __('translate.Urgent') }}</span>
                                                                @endif
                                                            </div>
                                                        </div>

                                                        <div class="job-listing-content">
                                                            <p>{{ currency($listing->regular_price) }}/{{ __('translate.m') }}</p>

                                                            <a href="{{ route('listing', $listing->slug) }}">
                                                                <h3 class="job-listing-content-link">{{ html_decode($listing->title) }}</h3>
                                                            </a>
                                                        </div>

                                                        <div class="job-listing-content-btn">
                                                            <a href="javascript:;">
                                                                <span>
                                                                    <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                                            d="M2.97888 0.513554C2.97888 0.298962 2.80492 0.125 2.59032 0.125C2.37573 0.125 2.20177 0.298962 2.20177 0.513554V1.7167C1.35167 2.14527 0.675371 2.86822 0.306805 3.75163H9.0185C8.64993 2.86823 7.97365 2.14529 7.12357 1.71672V0.513554C7.12357 0.298962 6.94961 0.125 6.73501 0.125C6.52042 0.125 6.34646 0.298962 6.34646 0.513554V1.4222C6.02048 1.33638 5.67823 1.29067 5.3253 1.29067H4C3.64709 1.29067 3.30485 1.33638 2.97888 1.42219V0.513554ZM0 5.29067C0 5.03013 0.0249108 4.7754 0.0724807 4.52874H9.25282C9.30039 4.7754 9.3253 5.03013 9.3253 5.29068V6.87501C9.3253 9.08415 7.53444 10.875 5.3253 10.875H4C1.79086 10.875 0 9.08415 0 6.87501V5.29067ZM4.66263 7.76653C4.94876 7.76653 5.18071 7.53458 5.18071 7.24846C5.18071 6.96234 4.94876 6.73039 4.66263 6.73039C4.37651 6.73039 4.14456 6.96234 4.14456 7.24846C4.14456 7.53458 4.37651 7.76653 4.66263 7.76653ZM7.25274 7.24846C7.25274 7.53458 7.02079 7.76653 6.73467 7.76653C6.44854 7.76653 6.21659 7.53458 6.21659 7.24846C6.21659 6.96234 6.44854 6.73039 6.73467 6.73039C7.02079 6.73039 7.25274 6.96234 7.25274 7.24846ZM2.59029 7.76653C2.87641 7.76653 3.10836 7.53458 3.10836 7.24846C3.10836 6.96234 2.87641 6.73039 2.59029 6.73039C2.30417 6.73039 2.07222 6.96234 2.07222 7.24846C2.07222 7.53458 2.30417 7.76653 2.59029 7.76653Z" />
                                                                    </svg>
                                                                </span>

                                                                {{ $listing->created_at->diffForHumans() }}
                                                            </a>


                                                            <a href="javascript:;">
                                                                <span>
                                                                    <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                                            d="M4.81644 11C6.56164 11 9.47029 7.58895 9.47029 4.88889C9.47029 2.18883 7.38669 0 4.81644 0C2.2462 0 0.162598 2.18883 0.162598 4.88889C0.162598 7.58895 3.07125 11 4.81644 11ZM4.81631 6.59992C5.67306 6.59992 6.36759 5.86119 6.36759 4.94992C6.36759 4.03865 5.67306 3.29992 4.81631 3.29992C3.95956 3.29992 3.26502 4.03865 3.26502 4.94992C3.26502 5.86119 3.95956 6.59992 4.81631 6.59992Z" />
                                                                    </svg>
                                                                </span>

                                                                {{ html_decode($listing->address) }}
                                                            </a>
                                                        </div>

                                                        <div class="job-listing-btn">
                                                            <a class="main-btn " href="{{ route('listing', ['slug' => $listing->slug,'is_apply' => 'yes']) }}">
                                                                <div class="btn_m">
                                                                    <div class="btn_c">
                                                                        <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                                                        <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                            <a class="main-btn two " href="{{ route('listing', $listing->slug) }}">
                                                                <div class="btn_m">
                                                                    <div class="btn_c">
                                                                        <div class="btn_t1">{{ __('translate.Detail Now') }}</div>
                                                                        <div class="btn_t2">{{ __('translate.Detail Now') }}</div>
                                                                    </div>
                                                                </div>
                                                            </a>


                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                <div class="  col-xxl-4 col-lg-6 col-sm-6" @if ($index > 2)  data-aos="fade-up" @endif>
                                                    <div class="features-single-box ">
                                                        <div class="features-thumb">
                                                            <img src="{{ asset($listing->thumb_image) }}" alt="img">
                                                        </div>

                                                        <div class="features-single-box-over">
                                                            <div class="text">
                                                                @if ($listing->is_urgent == 'enable')
                                                                <p>{{ __('translate.Urgent') }}</p>
                                                                @endif

                                                                @if ($listing->is_featured == 'enable')
                                                                <h6>{{ __('translate.Featured') }}</h6>
                                                                @endif
                                                            </div>

                                                            <div class="icon">
                                                                @guest('web')
                                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                @else
                                                                    <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                @endguest

                                                            </div>
                                                        </div>


                                                        <div class="features-single-box-inner">
                                                            <div class="features-single-box-inner-txt">
                                                                <p>

                                                                    <span>
                                                                        <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                                            xmlns="http://www.w3.org/2000/svg">
                                                                            <path
                                                                                d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                                                        </svg>
                                                                    </span>
                                                                    {{ $listing?->sub_category?->name }}
                                                                </p>

                                                                <span>
                                                                    {{ currency($listing->regular_price) }}
                                                                </span>
                                                            </div>


                                                            <a href="{{ route('listing', $listing->slug) }}">
                                                                <h3>{{ html_decode($listing->title) }}</h3>
                                                            </a>


                                                            <div class="features-single-box-contact">
                                                                <div class="location">
                                                                    <p><a href="javascript:;">
                                                                            <span>
                                                                                <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                        d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                                                </svg>
                                                                            </span>
                                                                            {{ html_decode($listing->address) }}
                                                                        </a>
                                                                    </p>
                                                                </div>

                                                                <div class="contact">
                                                                    <p>
                                                                        <a href="{{ route('agent', $listing?->agent?->username) }}">
                                                                            <span>
                                                                                <svg width="13" height="16" viewBox="0 0 13 16" fill="none"
                                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                        d="M6.22222 7.11111C8.1859 7.11111 9.77778 5.51923 9.77778 3.55556C9.77778 1.59188 8.1859 0 6.22222 0C4.25854 0 2.66667 1.59188 2.66667 3.55556C2.66667 5.51923 4.25854 7.11111 6.22222 7.11111ZM6.22222 16C9.65866 16 12.4444 14.4081 12.4444 12.4444C12.4444 10.4808 9.65866 8.88889 6.22222 8.88889C2.78578 8.88889 0 10.4808 0 12.4444C0 14.4081 2.78578 16 6.22222 16Z" />
                                                                                </svg>
                                                                            </span>
                                                                            {{ $listing?->agent?->name }}
                                                                        </a>
                                                                    </p>
                                                                    <p>
                                                                        <a href="javascript:;">
                                                                            <span>
                                                                                <svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                        d="M4.64157 0.605422C4.64157 0.271056 4.37051 0 4.03614 0C3.70178 0 3.43072 0.271057 3.43072 0.605422V1.85647C1.54458 2.12521 0.0823859 3.70969 0.00336393 5.65071H14.5268C14.4477 3.70969 12.9855 2.12521 11.0994 1.85647V0.605422C11.0994 0.271057 10.8283 0 10.494 0C10.1596 0 9.88855 0.271057 9.88855 0.605422V1.81627H4.64157L4.64157 0.605422ZM1.54674e-05 6.86155H14.5301V12.75C14.5301 14.9591 12.7393 16.75 10.5301 16.75H4C1.79086 16.75 0 14.9591 0 12.75V6.86155H1.54674e-05ZM7.26508 11.9066C7.7109 11.9066 8.0723 11.5452 8.0723 11.0994C8.0723 10.6536 7.7109 10.2922 7.26508 10.2922C6.81926 10.2922 6.45785 10.6536 6.45785 11.0994C6.45785 11.5452 6.81926 11.9066 7.26508 11.9066ZM11.3012 11.0994C11.3012 11.5452 10.9398 11.9066 10.494 11.9066C10.0482 11.9066 9.68676 11.5452 9.68676 11.0994C9.68676 10.6536 10.0482 10.2922 10.494 10.2922C10.9398 10.2922 11.3012 10.6536 11.3012 11.0994ZM4.03616 11.9066C4.48198 11.9066 4.84339 11.5452 4.84339 11.0994C4.84339 10.6536 4.48198 10.2922 4.03616 10.2922C3.59034 10.2922 3.22893 10.6536 3.22893 11.0994C3.22893 11.5452 3.59034 11.9066 4.03616 11.9066Z" />
                                                                                </svg>
                                                                            </span>
                                                                            {{ $listing->created_at->diffForHumans() }}
                                                                        </a>
                                                                    </p>
                                                                </div>
                                                            </div>

                                                        </div>

                                                    </div>
                                                </div>
                                            @endif
                                        @empty
                                            <div class="col-12" data-aos="fade-up">
                                                <section class="maintenance common-class">
                                                    <div class="container">
                                                        <div class="row justify-content-center ">
                                                            <div class="col-lg-7">
                                                                <div class="maintenance-item">
                                                                    <div class="maintenance-thumb">
                                                                        <img src="{{ asset($setting->not_found) }}" alt="thumg">
                                                                    </div>

                                                                    <div class="maintenance-item-txt">
                                                                        <h2>{{ __('translate.Sorry!! Listing Not Found') }}</h2>
                                                                        <p>{{ __('translate.Whoops... this information is not available for a moment') }}</p>
                                                                        <a class="main-btn " href="{{ route('listings', ['category' => request()->get('category')]) }}">
                                                                            <div class="btn_m">
                                                                                <div class="btn_c">
                                                                                    <div class="btn_t1">{{ __('translate.Back to Listing') }}</div>
                                                                                    <div class="btn_t2">{{ __('translate.Back to Listing') }}</div>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </section>
                                            </div>
                                        @endforelse

                                    </div>
                                </div>

                                <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                    aria-labelledby="pills-profile-tab">
                                    <div class="row mt-20px  g-3">
                                        @forelse ($listings as $index => $listing)
                                            @if ($listing->category_id == 3)
                                                <div class="col-xl-6 col-lg-12 col-sm-6 col-md-12 aos-init aos-animate features-two" @if ($index > 2)  data-aos="fade-up" @endif>
                                                    <div class="features-two-item">
                                                        <div class="features-two-inner">
                                                            <div class="features-two-img">
                                                                <img src="{{ asset($listing->thumb_image) }}" alt="img">

                                                                <div class="features-two-img-overlay">
                                                                    @if ($listing->is_urgent == 'enable')
                                                                        <h6 class="txt">{{ __('translate.Urgent') }}</h6>
                                                                        @endif

                                                                        @if ($listing->is_featured == 'enable')
                                                                        <h6 class="txt two">{{ __('translate.Featured') }}</h6>
                                                                    @endif
                                                                </div>

                                                            </div>

                                                            <div class="features-two-text-item">
                                                                <div class="features-two-text-item-top">
                                                                    <div class="left">
                                                                        <h6>
                                                                            <span>
                                                                                <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                                    <path
                                                                                        d="M10.9992 3.43685C10.9992 4.03875 11.001 4.64023 10.9984 5.24213C10.9971 5.59801 10.8734 5.90737 10.6216 6.16071C10.253 6.53167 9.88231 6.90005 9.51201 7.26973C8.1817 8.59848 6.8514 9.92723 5.52152 11.2564C5.40297 11.3749 5.27925 11.4852 5.11717 11.5408C4.78523 11.6545 4.47658 11.6071 4.21276 11.3775C3.99593 11.1883 3.79548 10.9798 3.59158 10.7764C2.52854 9.71482 1.46636 8.65191 0.405044 7.58899C0.330468 7.51445 0.257184 7.43733 0.192523 7.35417C-0.0816435 7.00001 -0.0622449 6.5097 0.245976 6.18311C0.471862 5.94356 0.708524 5.71391 0.941737 5.48082C2.27248 4.14991 3.60365 2.81944 4.93439 1.48896C5.11415 1.3093 5.29089 1.12618 5.47453 0.949964C5.70904 0.724627 5.99527 0.60485 6.31815 0.603126C7.545 0.597956 8.77142 0.600972 9.99827 0.600972C10.275 0.600972 10.5255 0.673356 10.7251 0.876718C10.8854 1.04001 10.982 1.23519 10.9885 1.46526C10.9971 1.80004 10.9975 2.13481 10.9992 2.46958C11.001 2.79186 10.9992 3.11414 10.9992 3.43642V3.43685ZM9.16327 3.35757C9.1706 2.86252 8.77271 2.45278 8.28603 2.43555C7.76571 2.41702 7.3355 2.82719 7.33075 3.3468C7.32644 3.83798 7.72562 4.24987 8.21059 4.26926C8.72616 4.28994 9.17318 3.86727 9.16327 3.35757Z" />
                                                                                </svg>
                                                                            </span>
                                                                            {{ $listing?->sub_category?->name }}
                                                                        </h6>
                                                                    </div>
                                                                    <div class="right">
                                                                        @guest('web')
                                                                            <a href="javascript:;" class="before_auth_wishlist">
                                                                                <span>
                                                                                    <svg width="24" height="21" viewBox="0 0 16 14" fill="none"
                                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                                        <path
                                                                                            d="M8.61204 1.324L8 1.96329L7.38796 1.324C5.69786 -0.441333 2.95767 -0.441334 1.26757 1.324C-0.422524 3.08933 -0.422525 5.95151 1.26757 7.71684L6.77592 13.4704C7.45196 14.1765 8.54804 14.1765 9.22408 13.4704L14.7324 7.71684C16.4225 5.95151 16.4225 3.08934 14.7324 1.324C13.0423 -0.441333 10.3021 -0.441334 8.61204 1.324Z" />
                                                                                    </svg>
                                                                                </span>
                                                                            </a>
                                                                        @else
                                                                        <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                                            <span>
                                                                                <svg width="24" height="21" viewBox="0 0 16 14" fill="none"
                                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                                    <path
                                                                                        d="M8.61204 1.324L8 1.96329L7.38796 1.324C5.69786 -0.441333 2.95767 -0.441334 1.26757 1.324C-0.422524 3.08933 -0.422525 5.95151 1.26757 7.71684L6.77592 13.4704C7.45196 14.1765 8.54804 14.1765 9.22408 13.4704L14.7324 7.71684C16.4225 5.95151 16.4225 3.08934 14.7324 1.324C13.0423 -0.441333 10.3021 -0.441334 8.61204 1.324Z" />
                                                                                </svg>
                                                                            </span>
                                                                        </a>

                                                                        @endif
                                                                    </div>
                                                                </div>


                                                                <a href="{{ route('listing', $listing->slug) }}">
                                                                    <h3 class="txt-link">{{ html_decode($listing->title) }}</h3>
                                                                </a>

                                                                <div class="btn-box">
                                                                    <a href="javascript:;">
                                                                        <span>
                                                                            <svg width="11" height="11" viewBox="0 0 11 11" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                    d="M3.81628 0.513554C3.81628 0.298962 3.64232 0.125 3.42773 0.125C3.21313 0.125 3.03917 0.298962 3.03917 0.513554V1.7167C2.18907 2.14527 1.51277 2.86822 1.14421 3.75163H9.8559C9.48734 2.86823 8.81106 2.14529 7.96097 1.71672V0.513554C7.96097 0.298962 7.78701 0.125 7.57242 0.125C7.35782 0.125 7.18386 0.298962 7.18386 0.513554V1.4222C6.85788 1.33638 6.51563 1.29067 6.1627 1.29067H4.8374C4.48449 1.29067 4.14225 1.33638 3.81628 1.42219V0.513554ZM0.837402 5.29067C0.837402 5.03013 0.862313 4.7754 0.909883 4.52874H10.0902C10.1378 4.7754 10.1627 5.03013 10.1627 5.29068V6.87501C10.1627 9.08415 8.37184 10.875 6.1627 10.875H4.8374C2.62827 10.875 0.837402 9.08415 0.837402 6.87501V5.29067ZM5.50004 7.76653C5.78616 7.76653 6.01811 7.53458 6.01811 7.24846C6.01811 6.96234 5.78616 6.73039 5.50004 6.73039C5.21391 6.73039 4.98196 6.96234 4.98196 7.24846C4.98196 7.53458 5.21391 7.76653 5.50004 7.76653ZM8.09014 7.24846C8.09014 7.53458 7.85819 7.76653 7.57207 7.76653C7.28595 7.76653 7.054 7.53458 7.054 7.24846C7.054 6.96234 7.28595 6.73039 7.57207 6.73039C7.85819 6.73039 8.09014 6.96234 8.09014 7.24846ZM3.42769 7.76653C3.71381 7.76653 3.94576 7.53458 3.94576 7.24846C3.94576 6.96234 3.71381 6.73039 3.42769 6.73039C3.14157 6.73039 2.90962 6.96234 2.90962 7.24846C2.90962 7.53458 3.14157 7.76653 3.42769 7.76653Z" />
                                                                            </svg>
                                                                        </span>

                                                                        {{ $listing->created_at->diffForHumans() }}
                                                                    </a>


                                                                    <a href="javascript:;" class="active">
                                                                        <span>
                                                                            <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                    d="M4.65385 11C6.39904 11 9.30769 7.58895 9.30769 4.88889C9.30769 2.18883 7.22409 0 4.65385 0C2.0836 0 0 2.18883 0 4.88889C0 7.58895 2.90865 11 4.65385 11ZM4.65371 6.59992C5.51046 6.59992 6.20499 5.86119 6.20499 4.94992C6.20499 4.03865 5.51046 3.29992 4.65371 3.29992C3.79696 3.29992 3.10243 4.03865 3.10243 4.94992C3.10243 5.86119 3.79696 6.59992 4.65371 6.59992Z"
                                                                                    fill="#FD4917" />
                                                                            </svg>
                                                                        </span>

                                                                        {{ html_decode($listing->address) }}
                                                                    </a>
                                                                </div>


                                                                <div class="btn-price">
                                                                    <p class="btn-price-txt">{{ currency($listing->regular_price) }}/{{ __('translate.m') }}</p>
                                                                    <a class="main-btn " href="{{ route('listing', ['slug' => $listing->slug,'is_apply' => 'yes']) }}">
                                                                        <div class="btn_m">
                                                                            <div class="btn_c">
                                                                                <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                                                                <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                                                                            </div>
                                                                        </div>
                                                                    </a>
                                                                </div>


                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                <div class=" col-xl-6 col-lg-12 col-sm-6 col-md-12" @if ($index > 2)  data-aos="fade-up" @endif>
                                                    <div class="new-listing-item">
                                                        <div class="new-listing-thumb">

                                                            <img src="{{ asset($listing->thumb_image) }}" alt="img">
                                                            <div class="new-listing-item-overlay">

                                                                @if ($listing->is_urgent == 'enable')
                                                                <h6 class="txt">{{ __('translate.Urgent') }}</h6>
                                                                @endif

                                                                @if ($listing->is_featured == 'enable')
                                                                <h6 class="txt two">{{ __('translate.Featured') }}</h6>
                                                                @endif

                                                                <div class="icon">
                                                                    @guest('web')
                                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 16 14"
                                                                                fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M8.71459 1.324L8.11105 1.96329L7.50752 1.324C5.84089 -0.441333 3.13876 -0.441334 1.47214 1.324C-0.194488 3.08933 -0.194488 5.95151 1.47214 7.71684L6.90398 13.4704C7.57063 14.1765 8.65148 14.1765 9.31813 13.4704L14.75 7.71684C16.4166 5.95151 16.4166 3.08934 14.75 1.324C13.0833 -0.441333 10.3812 -0.441334 8.71459 1.324Z">
                                                                                </path>
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                    @else
                                                                    <a href="{{ route('user.add-to-wishlist', $listing->id) }}">
                                                                        <span>
                                                                            <svg width="24" height="21" viewBox="0 0 16 14"
                                                                                fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M8.71459 1.324L8.11105 1.96329L7.50752 1.324C5.84089 -0.441333 3.13876 -0.441334 1.47214 1.324C-0.194488 3.08933 -0.194488 5.95151 1.47214 7.71684L6.90398 13.4704C7.57063 14.1765 8.65148 14.1765 9.31813 13.4704L14.75 7.71684C16.4166 5.95151 16.4166 3.08934 14.75 1.324C13.0833 -0.441333 10.3812 -0.441334 8.71459 1.324Z">
                                                                                </path>
                                                                            </svg>
                                                                        </span>
                                                                    </a>
                                                                    @endguest
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="new-listing-inner">
                                                            <div class="new-listing-inner-txt">
                                                                <p>
                                                                    <a href="{{ route('listings', ['sub_category_id' => $listing->category_id, 'category' => 'classified']) }}">
                                                                        <span>
                                                                            <svg width="11" height="12" viewBox="0 0 11 12"
                                                                                fill="none"
                                                                                xmlns="http://www.w3.org/2000/svg">
                                                                                <path
                                                                                    d="M10.9992 3.43667C10.9992 4.03857 11.001 4.64004 10.9984 5.24195C10.9971 5.59783 10.8734 5.90718 10.6216 6.16053C10.253 6.53149 9.88231 6.89987 9.51201 7.26954C8.1817 8.5983 6.8514 9.92705 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5406C4.78523 11.6543 4.47658 11.6069 4.21276 11.3773C3.99593 11.1882 3.79548 10.9796 3.59158 10.7763C2.52854 9.71464 1.46636 8.65172 0.405044 7.58881C0.330468 7.51427 0.257184 7.43714 0.192523 7.35399C-0.0816435 6.99983 -0.0622449 6.50952 0.245976 6.18293C0.471862 5.94338 0.708524 5.71373 0.941737 5.48064C2.27248 4.14973 3.60365 2.81925 4.93439 1.48878C5.11415 1.30911 5.29089 1.126 5.47453 0.949781C5.70904 0.724444 5.99527 0.604667 6.31815 0.602943C7.545 0.597773 8.77142 0.600789 9.99827 0.600789C10.275 0.600789 10.5255 0.673172 10.7251 0.876535C10.8854 1.03983 10.982 1.23501 10.9885 1.46508C10.9971 1.79985 10.9975 2.13463 10.9992 2.4694C11.001 2.79168 10.9992 3.11396 10.9992 3.43624V3.43667ZM9.16327 3.35739C9.1706 2.86234 8.77271 2.4526 8.28603 2.43536C7.76571 2.41684 7.3355 2.82701 7.33075 3.34662C7.32644 3.83779 7.72562 4.24969 8.21059 4.26908C8.72616 4.28976 9.17318 3.86709 9.16327 3.35739Z">
                                                                                </path>
                                                                            </svg>
                                                                        </span>
                                                                        {{ $listing?->sub_category?->name }}
                                                                    </a>
                                                                </p>


                                                            </div>

                                                            <a href="{{ route('listing', $listing->slug) }}">
                                                                <h4>{{ html_decode($listing->title) }}</h4>
                                                            </a>

                                                            <div class="contact-box">
                                                            <span>{{ currency($listing->regular_price) }}</span>
                                                                <a href="javascript:;">
                                                                    <span>
                                                                        <svg width="15" height="17" viewBox="0 0 15 17"
                                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                                d="M4.87643 0.730422C4.87643 0.396056 4.60537 0.125 4.27101 0.125C3.93664 0.125 3.66559 0.396057 3.66559 0.730422V1.98147C1.77944 2.25021 0.317249 3.83469 0.238227 5.77571H14.7616C14.6826 3.83469 13.2204 2.25021 11.3343 1.98147V0.730422C11.3343 0.396057 11.0632 0.125 10.7288 0.125C10.3945 0.125 10.1234 0.396057 10.1234 0.730422V1.94127H4.87643L4.87643 0.730422ZM0.234879 6.98655H14.765V12.875C14.765 15.0841 12.9741 16.875 10.765 16.875H4.23486C2.02572 16.875 0.234863 15.0841 0.234863 12.875V6.98655H0.234879ZM7.49994 12.0316C7.94576 12.0316 8.30717 11.6702 8.30717 11.2244C8.30717 10.7786 7.94576 10.4172 7.49994 10.4172C7.05412 10.4172 6.69271 10.7786 6.69271 11.2244C6.69271 11.6702 7.05412 12.0316 7.49994 12.0316ZM11.5361 11.2244C11.5361 11.6702 11.1747 12.0316 10.7289 12.0316C10.283 12.0316 9.92163 11.6702 9.92163 11.2244C9.92163 10.7786 10.283 10.4172 10.7289 10.4172C11.1747 10.4172 11.5361 10.7786 11.5361 11.2244ZM4.27102 12.0316C4.71684 12.0316 5.07825 11.6702 5.07825 11.2244C5.07825 10.7786 4.71684 10.4172 4.27102 10.4172C3.8252 10.4172 3.46379 10.7786 3.46379 11.2244C3.46379 11.6702 3.8252 12.0316 4.27102 12.0316Z">
                                                                            </path>
                                                                        </svg>
                                                                    </span>
                                                                    {{ $listing->created_at->diffForHumans() }}
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @empty

                                            <div class="col-12" data-aos="fade-up">
                                                <section class="maintenance common-class">
                                                    <div class="container">
                                                        <div class="row justify-content-center ">
                                                            <div class="col-lg-7">
                                                                <div class="maintenance-item">
                                                                    <div class="maintenance-thumb">
                                                                        <img src="{{ asset($setting->not_found) }}" alt="thumg">
                                                                    </div>

                                                                    <div class="maintenance-item-txt">
                                                                        <h2>{{ __('translate.Sorry!! Listing Not Found') }}</h2>
                                                                        <p>{{ __('translate.Whoops... this information is not available for a moment') }}</p>
                                                                        <a class="main-btn " href="{{ route('listings', ['category' => request()->get('category')]) }}">
                                                                            <div class="btn_m">
                                                                                <div class="btn_c">
                                                                                    <div class="btn_t1">{{ __('translate.Back to Listing') }}</div>
                                                                                    <div class="btn_t2">{{ __('translate.Back to Listing') }}</div>
                                                                                </div>
                                                                            </div>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </section>
                                            </div>
                                        @endforelse

                                    </div>
                                </div>

                            </div>

                            {{ $listings->links('pagination_box') }}

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Classified Listings part end  -->

</main>
@endsection

@push('style_section')
<link rel="stylesheet" href="{{ asset('frontend/css/nouislider.min.css') }}">
@endpush

@push('js_section')

<script src="{{ asset('frontend/assets/js/nouislider.min.js') }}"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function () {

                $("#sub_category_id").on("change", function(e){
                    let sub_category_id = $(this).val();

                    if(sub_category_id){
                        $.ajax({
                            type: "get",
                            url: "{{ url('child-categories-by-sub-category') }}" + "/" + sub_category_id,
                            success: function(response) {
                                $("#child_category_id").html(response)
                            },
                            error: function(response){
                                let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                                $("#child_category_id").html(empty_html)
                            }
                        });
                    }else{
                        let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                        $("#child_category_id").html(empty_html)
                    }
                })


                $("#listing_filter_btn").on("click",function(e){
                    $("#listing_filter_form").submit();
                })


                $("#country_id").on("change", function(e){
                    let country_id = $(this).val();

                    if(country_id){
                        $.ajax({
                            type: "get",
                            url: "{{ url('cities-by-country') }}" + "/" + country_id,
                            success: function(response) {
                                $("#city_id").html(response)

                            },
                            error: function(response){
                                let empty_html = `<option value="">{{ __('translate.Select City') }}</option>`;
                                $("#city_id").html(empty_html)
                            }
                        });
                    }else{
                        let empty_html = `<option value="">{{ __('translate.Select City') }}</option>`;
                        $("#city_id").html(empty_html)
                    }
                })


            });

        })(jQuery);

        // range slider----------------------------------------
        function priceslider() {
           let max_price = "{{ $max_price }}";
           let selected_min_price = "{{ $selected_min_price }}";
           let selected_max_price = "{{ $selected_max_price }}";

            if ($("#slider-tooltips").length > 0) {
                let tooltipSlider = document.getElementById("slider-tooltips");

                let formatForSlider = {
                from: function (formattedValue) {
                    return Number(formattedValue);
                },
                to: function (numericValue) {
                    return Math.round(numericValue);
                },
                };

                noUiSlider.create(tooltipSlider, {
                start: [parseInt(selected_min_price), parseInt(selected_max_price)],
                connect: true,
                format: formatForSlider,
                range: {
                    min: 0,
                    max: parseInt(max_price),
                },
                });
                let formatValues = [
                document.getElementById("slider-margin-value-min"),
                document.getElementById("slider-margin-value-max"),
                ];
                tooltipSlider.noUiSlider.on("update", function (values, handle, unencoded) {
                    formatValues[0].innerHTML = "{{ __('translate.Range') }}: " +  currency_position(values[0]);
                    formatValues[1].innerHTML = currency_position(values[1]);

                    let currency_rate = "{{ Session::get('currency_rate') }}";
                    $("#min_price").val((values[0] * currency_rate));
                    $("#max_price").val((values[1]*currency_rate));
                });
            }
        };

        priceslider();

        function currency_position(price){
            let currency_icon = "{{ Session::get('currency_icon') }}";
            let currency_code = "{{ Session::get('currency_code') }}";
            let currency_rate = "{{ Session::get('currency_rate') }}";
            let currency_position = "{{ Session::get('currency_position') }}";
            let return_price = '';
            let convert_price = price * currency_rate;
            if(currency_position == 'before_price'){
                return_price = `${currency_icon}${convert_price}`;
            }else if(currency_position == 'before_price_with_space'){
                return_price = `${currency_icon} ${convert_price}`;
            }else if(currency_position == 'after_price'){
                return_price = `${convert_price}${currency_icon}`;
            }else if(currency_position == 'after_price_with_space'){
                return_price = `${convert_price} ${currency_icon}`;
            }else{
                return_price = `${currency_icon}${convert_price}`;
            }

            return return_price;

        }


    </script>
@endpush
