<?php

use Modules\ContactMessage\Http\Controllers\ContactMessageController;
use Modules\ContactMessage\Http\Controllers\Frontend\ContactMessageController as FrontendContactMessageController;


Route::group(['as'=> 'admin.', 'prefix' => 'admin', 'middleware' => ['auth:admin', 'XSS','DEMO']],function (){

    Route::controller(ContactMessageController::class)->group(function () {
        Route::get('contact-message', 'contact_message')->name('contact-message');
        Route::get('show-message/{id}', 'show_message')->name('show-message');
        Route::delete('delete-contact-message/{id}', 'delete_message')->name('delete-contact-message');
        Route::put('contact-message-setting', 'contact_message_setting')->name('contact-message-setting');
    });

});

Route::group(['middleware' => ['XSS','HtmlSpecialchars','DEMO', 'LangSession']], function () {
    Route::post('store-contact-message', [FrontendContactMessageController::class, 'store_contact_message'])->name('store-contact-message');
    Route::post('store-agent-contact-message/{agent_id}', [FrontendContactMessageController::class, 'store_agent_contact_message'])->name('store-agent-contact-message');
});


