<?php

namespace Modules\Page\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Intervention\Image\ImageManager;
use Modules\Language\Entities\Language;
use Modules\Page\Entities\EcomBanner;
use Modules\Page\Entities\EcomBannerTranslation;

class EcomBannerController extends Controller
{
    public function index()
    {
        $banners = EcomBanner::with('translate')->latest()->get();
        return view('page::banner.index', compact('banners'));
    }

    public function create()
    {
        return view('page::banner.create');
    }

    public function store(Request $request, $id = null)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'sub_title' => 'nullable|string|max:255',
            'description' => 'nullable|string',
            'button_text' => 'nullable|string|max:255',
            'button_url' => 'nullable|string|max:255',
            'position' => 'nullable|string|in:left,center,right',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        ]);

        // Find or create the banner
        $banner = $id ? EcomBanner::findOrFail($id) : new EcomBanner();
        $banner->button_url = $request->button_url;
        $banner->position = $request->position ?? 'left';

        if ($request->hasFile('image')) {
            $image_path = uploadFile($request->file('image'), 'uploads/custom-images', $banner->image );
            $banner->image = $image_path;
        }
        $banner->save();

        $languages = Language::all();
        foreach ($languages as $language) {
            $translation = EcomBannerTranslation::firstOrNew([
                'lang_code' => $language->lang_code,
                'banner_id' => $banner->id,
            ]);

            $translation->title = $request->input('title') ?? null;
            $translation->sub_title = $request->input('sub_title') ?? null;
            $translation->description = $request->input('description') ?? null;
            $translation->button_text = $request->input('button_text') ?? null;
            $translation->save();
        }

        // Notification
        $notification = trans('translate.' . ($id ? 'Updated Successfully' : 'Created Successfully'));
        $notification = ['messege' => $notification, 'alert-type' => 'success'];

        return redirect()->route('admin.banner.index')->with($notification);
    }

    public function edit($id)
    {
        $banner = EcomBanner::findOrFail($id);

        return view('page::banner.create', compact('banner'));
    }
}
