@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Support Tickets') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.Support Tickets') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Support') }} >> {{ __('translate.Support Ticket') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div
                                        class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div
                                            class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title">{{ __('translate.Support Ticket') }}</h4>
                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">

                                    <table class="crancy-table__main crancy-table__main-v3 dataTable no-footer"
                                           id="dataTable">
                                        <!-- crancy Table Head -->
                                        <thead class="crancy-table__head">
                                        <tr>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                {{ __('Ticket ID') }}
                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                {{ __('User Info') }}
                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                {{ __('Unread Messages') }}
                                            </th>


                                            <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                {{ __('translate.Status') }}
                                            </th>

                                            <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                                {{ __('translate.Action') }}
                                            </th>

                                        </tr>
                                        </thead>
                                        <!-- crancy Table Body -->
                                        <tbody class="crancy-table__body">
                                        @foreach ($support_tickets as $index => $ticket)
                                            <tr class="odd">

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">{{ $ticket->ticket_id }}</h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        <p>
                                                            {{__('Name')}}: {{ $ticket?->user?->name }}
                                                        </p>
                                                        <p>{{__('User Type')}} : {{__('Client')}}</p>
                                                        <p>{{__('Email')}} : {{ $ticket->user->email  }}</p>
                                                        <p>{{__('Phone')}} : {{ $ticket->user->Phone  }}</p>
                                                    </h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        @php
                                                            $unseen_message = Modules\SupportTicket\Entities\TicketMessage::where('seen_by_admin', 'no')->where('support_ticket_id', $ticket->id)->count();
                                                        @endphp
                                                        @if ($unseen_message > 0)
                                                            <span
                                                                class="badge badge-danger">{{ $unseen_message }}</span>
                                                        @endif
                                                    </h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        @if($ticket->status == 'pending')
                                                            <span class="badge badge-danger">{{__('Pending')}}</span>
                                                        @elseif ($ticket->status == 'in_progress')
                                                            <span
                                                                class="badge badge-success">{{__('In Progress')}}</span>
                                                        @elseif ($ticket->status == 'closed')
                                                            <span class="badge badge-danger">{{__('Closed')}}</span>
                                                        @endif
                                                    </h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <a href="{{ route('admin.support-tickets.show',$ticket->ticket_id) }}"
                                                       class="crancy-btn"><i class="fas fa-eye"></i> {{ __('View') }}
                                                    </a>
                                                    @if($ticket->status != 'closed')
                                                        <a onclick="itemDeleteConfirmation({{ $ticket->id }})"
                                                           href="javascript:" data-bs-toggle="modal"
                                                           data-bs-target="#exampleModal"
                                                           class="crancy-btn delete_danger_btn"><i
                                                                class="fas fa-eye-slash"></i> {{ __('translate.Close') }}
                                                        </a>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                        <!-- End crancy Table Body -->
                                    </table>
                                </div>
                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                    @if ($support_tickets->hasPages())
                        <div class="col-lg-12">
                            {{ $support_tickets->links('pagination_box') }}
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </section>
    <!-- End currency Dashboard -->

    <!-- Closed Confirmation Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Close Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('translate.Are you sure to closed this support?') }}</p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        @csrf
                        @method('PUT')
                        <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Close') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js_section')
    <script>
        "use strict"

        function itemDeleteConfirmation(id) {
            document.getElementById("item_delect_confirmation").action = `{{ route('admin.ticket-closed', '') }}/${id}`;
        }
    </script>
@endpush
