<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Listing\Entities\Listing;

class JobRequest extends Model
{
    use HasFactory;

    public function agent(){
        return $this->belongsTo(User::class, 'agent_id')->select('id', 'image', 'email', 'name', 'designation', 'phone', 'address', 'resume');
    }

     public function user(){
        return $this->belongsTo(User::class, 'user_id')->select('id', 'image', 'email', 'name', 'designation', 'phone', 'address', 'resume');
    }

    public function listing(){
        return $this->belongsTo(Listing::class)->select('id', 'thumb_image', 'slug', 'agent_id', 'regular_price');
    }

}
