@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
    <main>


        <!-- inner-bg  part start  -->

        <div class="inner-bg common-class" style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="inner-bg-txt">
                            <h1>{{ __('translate.Faq') }}</h1>

                            <ul>
                                <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                                <li><span>
                                        <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                        </svg>

                                    </span></li>
                                <li><a href="javascript:;" class="active">{{ __('translate.Faq') }}</a></li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <!-- inner-bg  part end  -->



        <!-- faq part start  -->
        <section class="faq ">
            <div class="container">


                <div class="row ">
                    <div class="col-lg-3">
                        <div class="d-flex align-items-start">
                            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist"
                                aria-orientation="vertical">
                                <button class="nav-link active" id="v-pills-home-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-home" type="button" role="tab"
                                    aria-controls="v-pills-home" aria-selected="true">

                                    <span>
                                        <svg width="38" height="38" viewBox="0 0 38 38" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M38 14.9433C37.9059 17.9097 37.2472 20.4681 35.8357 22.791C35.5533 23.2619 35.522 23.67 35.7102 24.1879C36.2277 25.5534 36.7139 26.9346 37.2001 28.3159C37.2942 28.5984 37.4668 28.9123 37.2001 29.1948C36.9021 29.5087 36.5728 29.3675 36.2591 29.2576C34.8476 28.771 33.4517 28.2845 32.0559 27.7665C31.6324 27.6096 31.3031 27.6723 30.8796 27.8607C29.4995 28.4571 28.6996 29.5087 27.8997 30.7801C24.8728 35.6143 20.4029 38 14.7098 38C12.0592 38 9.54985 37.2309 7.29141 35.8183C6.77385 35.4887 6.31902 35.4416 5.75441 35.6614C4.46835 36.1636 3.15092 36.6031 1.84918 37.0583C1.51982 37.1681 1.1591 37.4036 0.814059 37.0897C0.453335 36.7601 0.704274 36.3991 0.814059 36.0695C1.30025 34.6882 1.78645 33.307 2.30401 31.9415C2.47653 31.4864 2.42948 31.1254 2.17854 30.6859C-2.33835 22.948 0.390601 13.5463 8.31085 9.43412C8.82841 9.16729 9.14208 8.7906 9.4087 8.28834C12.3259 2.92047 16.8584 0.0795748 22.928 0.00109709C30.613 -0.0930762 37.0903 5.88693 37.8588 13.5463C37.9216 14.0957 37.9686 14.645 38 14.9433ZM15.0705 36.8856C15.6978 36.8542 16.3252 36.8856 16.9525 36.7914C24.763 35.6771 30.0484 28.5984 28.9505 20.782C27.7429 12.1808 18.4582 6.65601 10.3027 9.71664C1.84918 12.8871 -1.50712 22.6655 3.24503 30.3563C3.60575 30.937 3.63712 31.4236 3.38618 32.0357C2.9784 33.0559 2.63336 34.0918 2.27264 35.1277C2.22559 35.2847 2.06875 35.473 2.24127 35.63C2.41379 35.7869 2.58631 35.63 2.75883 35.5672C3.79395 35.2062 4.84476 34.8609 5.84851 34.4528C6.42881 34.2174 6.89932 34.2488 7.44824 34.6098C9.73806 36.1636 12.2945 36.917 15.0705 36.8856Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M12.8119 24.9255C12.8119 24.6115 12.8119 24.2976 12.8119 23.9837C12.8119 22.32 13.204 21.8648 14.8664 21.6294C16.6701 21.3783 17.4856 19.4634 16.4348 18.0351C15.384 16.6225 13.3138 16.9207 12.4825 18.6158C12.012 19.6047 11.3062 20.0598 10.475 19.9186C9.25169 19.7145 8.64003 18.6001 9.06348 17.3759C9.87903 15.0059 12.4825 13.2951 15.0076 13.4834C17.7209 13.6874 19.9793 15.6965 20.4341 18.3333C20.889 20.9702 19.6343 23.4972 17.2033 24.7057C16.6544 24.9725 16.4348 25.3021 16.4662 25.9143C16.4975 26.7618 16.3093 27.5309 15.4938 28.0018C14.3332 28.6453 12.953 27.9233 12.8276 26.5892C12.7805 26.0241 12.8276 25.4591 12.8119 24.9255Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M14.585 28.9909C15.6358 28.9752 16.4984 29.8385 16.4828 30.8587C16.4671 31.8632 15.6358 32.6794 14.6164 32.6794C13.6127 32.6794 12.7971 31.8632 12.7971 30.843C12.7814 29.8228 13.5656 29.0066 14.585 28.9909Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M2.99378 19.9657C3.60544 17.5015 4.84445 15.3983 6.75786 13.6875C6.99311 13.4835 7.27542 13.3893 7.52636 13.6561C7.80866 13.9544 7.68319 14.2369 7.44794 14.4723C5.76979 16.0419 4.62488 17.941 4.04459 20.1698C3.96617 20.4837 3.77796 20.7662 3.37019 20.6563C3.04083 20.5622 2.94673 20.2953 2.99378 19.9657Z"
                                                fill="#FD4917" />
                                        </svg>
                                    </span>
                                    {{ __('translate.General Questions') }}
                                </button>

                                <button class="nav-link" id="v-pills-profile-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-profile" type="button" role="tab"
                                    aria-controls="v-pills-profile" aria-selected="false">

                                    <span>
                                        <svg width="34" height="38" viewBox="0 0 34 38" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M20.0924 3.18459C20.0924 3.37695 20.1516 3.6137 20.0776 3.77646C19.6333 4.69386 20.1516 5.15255 20.8031 5.70003C21.7656 6.48426 22.3135 7.57921 22.506 8.80734C22.58 9.28083 22.7281 9.414 23.2316 9.22165C24.6235 8.68897 26.045 8.74815 27.4073 9.36961C27.8811 9.59157 28.1328 9.48799 28.4734 9.13287C29.3915 8.20068 30.502 7.74198 31.8347 8.12669C33.0193 8.46702 33.6708 9.29563 33.9374 10.4794C34.2779 12.033 33.0785 13.7494 31.3164 14.1194C30.813 14.2229 30.6353 14.3709 30.5909 14.9036C30.4724 16.398 29.8061 17.641 28.6511 18.6028C28.2513 18.9431 28.2809 19.1058 28.6659 19.4314C29.8357 20.4079 30.502 21.6805 30.6057 23.2045C30.6353 23.678 30.813 23.7964 31.2572 23.8852C33.0193 24.2403 34.2631 25.9271 33.9522 27.466C33.7152 28.6349 33.0785 29.4931 31.8939 29.863C30.6353 30.2626 29.5099 29.9074 28.6363 29.0196C28.118 28.4869 27.7478 28.5017 27.1259 28.7533C25.8821 29.2712 24.579 29.286 23.2908 28.8125C22.8169 28.6349 22.5948 28.6497 22.506 29.212C22.2543 30.7213 21.4695 31.9198 20.2256 32.7928C19.8851 33.0295 19.7962 33.2515 19.9295 33.651C20.1812 34.4204 20.1812 35.2046 19.9147 35.9741C19.4409 37.365 18.1082 38.164 16.5978 37.9716C15.2651 37.7941 14.1546 36.5807 14.0806 35.1751C14.0509 34.6572 14.0213 34.1245 14.2286 33.6362C14.3915 33.2367 14.2582 33.0147 13.9325 32.778C12.6887 31.8902 11.9187 30.6917 11.6669 29.1824C11.5781 28.6941 11.43 28.5905 10.9414 28.7829C9.56428 29.3008 8.17238 29.2564 6.83971 28.6645C6.36587 28.4574 6.08453 28.4574 5.69953 28.8717C5.00358 29.6263 4.12994 30.0406 3.06381 29.9962C1.83479 29.937 0.798265 29.1824 0.383656 28.0135C-0.0309528 26.8741 0.294811 25.5424 1.18326 24.773C1.71633 24.3143 2.30863 23.9444 3.00458 23.8556C3.40438 23.8112 3.53764 23.6484 3.56726 23.2489C3.67091 21.6953 4.32244 20.408 5.52184 19.4018C5.92164 19.0615 5.89203 18.8987 5.50704 18.5732C4.32244 17.5818 3.6561 16.2797 3.56726 14.726C3.53764 14.3265 3.37476 14.2081 2.98977 14.1342C1.19807 13.7642 -0.0605677 12.1218 0.250389 10.5238C0.472501 9.34002 1.13884 8.49661 2.30863 8.12669C3.56726 7.72718 4.69263 8.0675 5.56627 8.9701C6.08453 9.48799 6.45471 9.48799 7.07663 9.23644C8.32045 8.71856 9.62351 8.70376 10.8969 9.17726C11.356 9.35482 11.5929 9.35482 11.6817 8.77775C11.9335 7.26848 12.7183 6.06995 13.9621 5.19695C14.3027 4.9602 14.4063 4.72345 14.2582 4.33874C14.0213 3.70248 14.0361 3.02183 14.1694 2.37078C14.51 0.802327 15.8723 -0.144662 17.5159 0.0181014C19.0114 0.151272 20.1072 1.49777 20.0924 3.18459ZM17.0865 28.1614C22.2395 28.1614 26.2819 24.1367 26.2671 18.9727C26.2671 13.853 22.2543 9.82831 17.1309 9.81352C11.9631 9.79872 7.92065 13.8086 7.90584 18.9579C7.90584 24.1219 11.9335 28.1614 17.0865 28.1614ZM27.8219 20.8666C27.3036 23.4709 26.0746 25.5276 24.1496 27.2736C25.349 27.6435 26.4892 27.54 27.2296 26.7705C27.9848 25.9715 28.5771 24.8913 28.888 23.8408C29.2138 22.8198 28.7251 21.784 27.8219 20.8666ZM15.7982 6.11434C14.7469 6.48426 14.0361 7.1797 13.5771 8.17108C13.5179 8.30425 13.4142 8.45222 13.5179 8.58539C13.6363 8.73336 13.7992 8.62978 13.9325 8.58539C14.9838 8.28946 16.0499 8.12669 17.1457 8.12669C18.2118 8.12669 19.2484 8.30425 20.2849 8.58539C20.4626 8.62978 20.7587 8.82214 20.7143 8.36344C20.6254 7.57921 19.1299 6.06995 18.4191 6.17353C17.5307 6.33629 16.6719 6.49906 15.7982 6.11434ZM24.194 10.6717C24.6827 11.2044 25.1269 11.6483 25.5267 12.1366C26.5632 13.3943 27.2592 14.8148 27.6738 16.398C27.7182 16.5904 27.6442 17.1083 28.118 16.768C29.0213 16.1169 29.2286 14.1046 28.4882 13.2907C28.1476 12.9208 27.8515 12.5065 27.7626 12.0182C27.6442 11.3672 27.2444 11.0416 26.6817 10.8197C25.9117 10.5238 25.1269 10.361 24.194 10.6717ZM18.4191 31.8606C19.4409 31.5055 20.1516 30.8248 20.6106 29.8778C20.6847 29.7299 20.8179 29.5523 20.6995 29.4043C20.5662 29.2268 20.3737 29.3748 20.2256 29.4191C19.2039 29.7151 18.1674 29.863 17.0865 29.863C16.0203 29.863 14.9838 29.6855 13.9473 29.4043C13.7696 29.36 13.4734 29.1528 13.5031 29.6115C13.5771 30.3809 15.0875 31.905 15.7982 31.8014C16.6867 31.6386 17.5455 31.4759 18.4191 31.8606ZM10.0233 10.6717C8.12796 10.213 7.0174 10.7457 6.33625 12.3585C6.2326 12.6101 6.08453 12.8468 5.92164 13.054C5.07762 14.1489 5.06281 15.4511 5.89203 16.5312C5.99568 16.6644 6.14376 16.8567 6.26222 16.8567C6.49914 16.8567 6.48433 16.5756 6.52875 16.398C6.85451 15.0663 7.4172 13.853 8.20199 12.7285C8.72025 12.0034 9.35697 11.382 10.0233 10.6717ZM10.0233 27.3032C9.56428 26.8149 9.14967 26.4006 8.76468 25.9567C7.68373 24.6694 6.94336 23.2193 6.52875 21.5917C6.48433 21.4141 6.57317 20.8814 6.08453 21.2366C5.18127 21.9024 4.98877 23.8852 5.72915 24.7138C6.06972 25.0837 6.35106 25.498 6.4399 25.9863C6.55836 26.6374 6.95817 26.9629 7.52085 27.17C8.32045 27.4512 9.09044 27.6139 10.0233 27.3032ZM4.91474 11.1896C4.92954 10.3906 4.14475 9.68035 3.22669 9.66555C2.4567 9.66555 1.90882 10.1834 1.89402 10.9529C1.87921 11.7223 2.70843 12.5361 3.53764 12.5509C4.27802 12.5657 4.89993 11.9442 4.91474 11.1896ZM30.9611 9.66555C30.043 9.68035 29.273 10.4054 29.3026 11.2044C29.3322 11.959 29.969 12.5805 30.6945 12.5361C31.5385 12.4917 32.353 11.6927 32.3233 10.9085C32.2937 10.1686 31.731 9.65075 30.9611 9.66555ZM3.19707 28.2946C4.10033 28.3094 4.91474 27.6139 4.91474 26.8149C4.91474 26.0603 4.32244 25.424 3.58207 25.424C2.76766 25.4092 1.89402 26.2231 1.89402 26.9925C1.89402 27.7471 2.44189 28.2946 3.19707 28.2946ZM30.9907 28.2946C31.7607 28.2946 32.3085 27.7619 32.3085 27.0073C32.3233 26.2379 31.4793 25.424 30.6501 25.424C29.9097 25.4092 29.2878 26.0307 29.2878 26.8001C29.2878 27.5991 30.0874 28.3094 30.9907 28.2946ZM15.7834 3.1402C15.7834 4.11679 16.3017 4.73825 17.1309 4.72345C17.9305 4.70865 18.4339 4.10199 18.4339 3.1698C18.4339 2.23761 17.9157 1.61614 17.1309 1.60135C16.3313 1.60135 15.7834 2.22281 15.7834 3.1402ZM18.4339 34.7903C18.4339 33.8434 17.9157 33.2515 17.1309 33.2367C16.3017 33.2219 15.7834 33.8434 15.7982 34.8347C15.813 35.7521 16.3609 36.3736 17.1457 36.3588C17.9157 36.344 18.4339 35.7225 18.4339 34.7903Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M14.836 15.377C15.4727 15.3474 16.0798 15.4954 16.5981 15.8653C16.9831 16.1464 17.2792 16.0873 17.6642 15.8505C19.1301 14.9775 20.907 15.3178 21.9287 16.6051C22.9653 17.9221 22.8764 19.6829 21.677 20.911C20.5961 22.0207 19.5003 23.1157 18.375 24.2106C17.5605 24.9949 16.6869 25.0097 15.8873 24.2402C14.7323 23.1305 13.5922 22.0059 12.4964 20.837C11.5487 19.8308 11.3266 18.6175 11.8745 17.345C12.4224 16.0725 13.4441 15.4214 14.836 15.377Z"
                                                fill="#FD4917" />
                                        </svg>
                                    </span>
                                    {{ __('translate.Community') }}
                                </button>

                                <button class="nav-link" id="v-pills-messages-tab" data-bs-toggle="pill"
                                    data-bs-target="#v-pills-messages" type="button" role="tab"
                                    aria-controls="v-pills-messages" aria-selected="false">
                                    <span>
                                        <svg width="38" height="38" viewBox="0 0 38 38" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M21.2879 0C29.4225 0 36.2999 6.20701 37.2168 14.4279C37.5274 17.2383 37.1725 19.9736 36.0632 22.5737C35.7822 23.2199 35.7822 23.791 36.0188 24.4373C36.6252 26.1205 37.1725 27.8489 37.7641 29.5472C38.1338 30.6443 38.1338 31.6663 37.2908 32.553C36.4182 33.4547 35.3829 33.4848 34.2884 33.094C32.4988 32.4628 30.6944 31.8466 28.9048 31.2154C28.5203 31.0801 28.1653 31.0501 27.766 31.2304C26.0355 31.9969 24.2459 32.5079 22.3528 32.583C21.8647 32.5981 21.5542 32.8686 21.2436 33.2143C18.7884 36.0848 15.6973 37.5577 11.9406 37.4975C10.6095 37.4825 9.29319 37.227 8.05083 36.686C7.4888 36.4455 6.97115 36.4305 6.40913 36.6409C5.29987 37.0617 4.17583 37.4374 3.05178 37.8282C2.17917 38.1288 1.33614 38.0686 0.641002 37.3773C-0.0837111 36.6559 -0.128081 35.7842 0.18251 34.8675C0.567052 33.7102 0.951594 32.5379 1.36572 31.3957C1.5432 30.8998 1.51362 30.4339 1.33614 29.9379C-0.497833 25.0685 0.714953 20.0488 4.56037 16.562C4.91533 16.2464 5.18155 15.9308 5.21113 15.3747C5.58088 9.54346 8.31705 5.12491 13.2273 2.14916C15.86 0.556076 18.3003 0 21.2879 0ZM34.8652 16.0511C34.8504 15.7054 34.8504 15.0892 34.7765 14.5031C33.7412 6.74805 26.7603 1.45782 19.099 2.63009C11.8075 3.74224 6.17249 10.8961 7.9325 19.2222C9.81084 28.0893 19.2173 32.6582 27.2631 28.7356C27.8695 28.435 28.402 28.405 29.0379 28.6304C30.8867 29.3067 32.765 29.9379 34.6286 30.5842C34.8948 30.6743 35.2054 30.9599 35.442 30.6894C35.6639 30.4339 35.3977 30.1183 35.3089 29.8477C34.7025 28.0142 34.1109 26.1957 33.4602 24.3772C33.1791 23.6107 33.2087 22.9644 33.5785 22.228C34.4807 20.3794 34.8948 18.3806 34.8652 16.0511ZM2.59329 35.3784C3.85045 34.9426 4.93012 34.642 5.93585 34.2062C6.8972 33.8004 7.72544 33.8455 8.6868 34.2813C11.9258 35.7692 16.2593 34.9426 18.5074 32.4778C11.4821 30.8246 7.08947 26.4512 5.35903 19.3124C5.24071 19.4025 5.18155 19.4326 5.12239 19.4927C5.00407 19.628 4.88575 19.7482 4.78222 19.8985C2.71161 22.8442 2.32707 26.0153 3.71734 29.3518C4.0723 30.1934 4.13146 30.9449 3.79129 31.8015C3.37716 32.8836 3.05178 34.0409 2.59329 35.3784Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M2.5 21L6 17.5L6.5 19L7.5 21L8.5 23L9.5 25L11.5 28C12.5 28.5 14.6 29.5 15 29.5C15.4 29.5 16.8333 30.5 17.5 31L20 32C19.8333 32.5 19.4 33.6 19 34C18.6 34.4 17.5 34.8333 17 35C16.5 35.1667 15.3 35.5 14.5 35.5C13.5 35.5 11 36 10.5 36C10.1 36 9 35.6667 8.5 35.5L6.5 35L5 36C4.16667 36.1667 2.4 36.5 2 36.5C1.6 36.5 1.5 35.8333 1.5 35.5L2 33L2.5 31L2 28L2.5 25.5V21Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M21.3036 14.8788C23.4186 14.8788 25.5336 14.8788 27.6485 14.8788C28.6395 14.8788 29.1127 15.2696 29.1275 16.0511C29.1423 16.8326 28.6395 17.3285 27.7225 17.3285C23.4186 17.3436 19.1147 17.3436 14.8108 17.3285C13.879 17.3285 13.3613 16.8326 13.3613 16.0811C13.3613 15.2996 13.8938 14.8788 14.8847 14.8638C17.0145 14.8788 19.159 14.8788 21.3036 14.8788Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M21.2592 12.5793C19.1147 12.5793 16.9701 12.5793 14.8255 12.5793C13.879 12.5793 13.3613 12.1435 13.3613 11.377C13.3613 10.6255 13.879 10.1296 14.8108 10.1145C19.0999 10.0995 23.389 10.0995 27.6781 10.1145C27.826 10.1145 27.9739 10.1446 28.1218 10.1747C28.8317 10.34 29.2015 10.8359 29.1275 11.5122C29.0684 12.1585 28.6395 12.5643 27.9148 12.5643C25.6962 12.5943 23.4777 12.5793 21.2592 12.5793Z"
                                                fill="#FD4917" />
                                            <path
                                                d="M18.6266 22.0326C17.3694 22.0326 16.1123 22.0476 14.8699 22.0326C13.8938 22.0175 13.3613 21.5667 13.3613 20.7852C13.3613 20.0337 13.8938 19.5678 14.8255 19.5528C17.4138 19.5377 19.9873 19.5377 22.5755 19.5528C23.4482 19.5528 23.951 20.0187 23.9658 20.7701C23.9806 21.5216 23.4777 22.0175 22.6199 22.0175C21.274 22.0476 19.9429 22.0326 18.6266 22.0326Z"
                                                fill="#FD4917" />
                                        </svg>
                                    </span>
                                    {{ __('translate.Support') }}
                                </button>
                            </div>
                        </div>
                    </div>


                    <div class="col-lg-9">

                        <div class="tab-content" id="v-pills-tabContent">
                            <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel"
                                aria-labelledby="v-pills-home-tab">

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="faq-thumb">
                                            <img src="{{ custom_asset($homepage->faq_image1, '336x414') }}" alt="img">
                                        </div>
                                    </div>


                                    <div class="col-lg-8">
                                        <div class="accordion" id="accordionExample">
                                            @foreach ($general_faqs as $index => $general_faq)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header"
                                                        id="general_faqheadingOne{{ $index }}">
                                                        <button
                                                            class="accordion-button {{ $index != 0 ? 'collapsed' : '' }}"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#general_faqcollapseOne{{ $index }}"
                                                            aria-expanded="true"
                                                            aria-controls="general_faqcollapseOne{{ $index }}">
                                                            {{ $general_faq->question }}
                                                        </button>
                                                    </h2>
                                                    <div id="general_faqcollapseOne{{ $index }}"
                                                        class="accordion-collapse collapse {{ $index == 0 ? 'show' : '' }}"
                                                        aria-labelledby="general_faqheadingOne{{ $index }}"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            {!! clean($general_faq->answer) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="v-pills-profile" role="tabpanel"
                                aria-labelledby="v-pills-profile-tab">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="faq-thumb">
                                            <img src="{{ custom_asset($homepage->faq_image1, '336x414') }}" alt="img">
                                        </div>
                                    </div>


                                    <div class="col-lg-8">
                                        <div class="accordion" id="accordionExample1">
                                            @foreach ($community_faqs as $index2 => $community_faq)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header"
                                                        id="community_faqheadingOne{{ $index2 }}">
                                                        <button
                                                            class="accordion-button {{ $index2 != 0 ? 'collapsed' : '' }}"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#community_faqcollapseOne{{ $index2 }}"
                                                            aria-expanded="true"
                                                            aria-controls="community_faqcollapseOne{{ $index2 }}">
                                                            {{ $community_faq->question }}
                                                        </button>
                                                    </h2>
                                                    <div id="community_faqcollapseOne{{ $index2 }}"
                                                        class="accordion-collapse collapse {{ $index2 == 0 ? 'show' : '' }}"
                                                        aria-labelledby="community_faqheadingOne{{ $index2 }}"
                                                        data-bs-parent="#accordionExample1">
                                                        <div class="accordion-body">
                                                            {!! clean($community_faq->answer) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="v-pills-messages" role="tabpanel"
                                aria-labelledby="v-pills-messages-tab">
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="faq-thumb">
                                            <img src="{{ custom_asset($homepage->faq_image1, '336x414') }}" alt="img">
                                        </div>
                                    </div>


                                    <div class="col-lg-8">
                                        <div class="accordion" id="accordionExample3">
                                            @foreach ($support_faqs as $index3 => $support_faq)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header"
                                                        id="support_faqheadingOne{{ $index3 }}">
                                                        <button
                                                            class="accordion-button {{ $index3 != 0 ? 'collapsed' : '' }}"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#support_faqcollapseOne{{ $index3 }}"
                                                            aria-expanded="true"
                                                            aria-controls="support_faqcollapseOne{{ $index3 }}">
                                                            {{ $support_faq->question }}
                                                        </button>
                                                    </h2>
                                                    <div id="support_faqcollapseOne{{ $index3 }}"
                                                        class="accordion-collapse collapse {{ $index3 == 0 ? 'show' : '' }}"
                                                        aria-labelledby="support_faqheadingOne{{ $index3 }}"
                                                        data-bs-parent="#accordionExample3">
                                                        <div class="accordion-body">
                                                            {!! clean($support_faq->answer) !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach


                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </section>
        <!-- faq part end  -->



        <!-- qustion part start  -->

        <section class="qustion footer-top-pad">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="qustion-thumb">
                            <img src="{{ custom_asset($homepage->faq_image2, '696x494') }}" alt="thumb">
                        </div>
                    </div>

                    <div class="col-lg-6 qustion-pl">
                        <h2 class="taitel">{{ __('translate.Ask any Question') }}</h2>
                        <p class="qustion-dec">
                            {{ __('translate.Do you have any more question about us, please fill out the form below to get response') }}
                        </p>

                        <form class="qustion-form-main" action="{{ route('store-contact-message') }}" method="POST">
                            @csrf
                            <div class="qustion-form-item">
                                <div class="qustion-form-inner">
                                    <label for="exampleFormControlInput1" class="form-label">{{ __('translate.Name') }}
                                        <span>*</span></label>
                                    <input type="text" class="form-control" id="exampleFormControlInput1"
                                        placeholder="{{ __('translate.Name Here') }}" name="name"
                                        value="{{ old('name') }}">
                                </div>
                                <div class="qustion-form-inner">
                                    <label for="exampleFormControlInput2"
                                        class="form-label">{{ __('translate.Email') }}<span>*</span></label>
                                    <input type="email" class="form-control" id="exampleFormControlInput2"
                                        placeholder="{{ __('translate.Email Address') }}" name="email"
                                        value="{{ old('email') }}">
                                </div>
                            </div>

                            <div class="qustion-form-item two">
                                <div class="qustion-form-inner">
                                    <label for="exampleFormControlInput1"
                                        class="form-label">{{ __('translate.Subject') }} <span>*</span></label>
                                    <input type="text" class="form-control" id="exampleFormControlInput1"
                                        placeholder="{{ __('translate.Subject') }}" name="subject"
                                        value="{{ old('subject') }}">
                                </div>

                            </div>

                            <div class="qustion-form-item two">
                                <div class="qustion-form-inner">
                                    <label for="exampleFormControlInput3"
                                        class="form-label">{{ __('translate.Message') }} <span>*</span></label>
                                    <textarea class="form-control" id="exampleFormControlInput3" rows="5"
                                        placeholder="{{ __('translate.Message here') }}" name="message">{{ old('message') }}</textarea>
                                </div>

                            </div>

                            @if ($google_recaptcha->status == 1)
                                <div class="qustion-form-item two">
                                    <div class="qustion-form-inner">
                                        <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                    </div>
                                </div>
                            @endif

                            <div class="qustion-form-item">

                                <a class="main-btn " href="javascript:;" id="contact_message_btn">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Send Message') }}</div>
                                            <div class="btn_t2">{{ __('translate.Send Message') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- qustion part end  -->

    </main>
@endsection



@push('js_section')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function() {

                $('#contact_message_btn').on("click", function() {
                    $(".qustion-form-main").submit();
                });

            });
        })(jQuery);
    </script>
@endpush
