<?php

namespace database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MenuSeeder extends Seeder
{
    public function run(): void
    {
        $menus = [
            [
                'id'         => 1,
                'name'       => 'Home',
                'location'   => 'header',
                'is_active'  => 1,
                'sort_order' => 1,
                'created_at' => '2025-08-12 04:34:56',
                'updated_at' => '2025-08-12 04:34:56',
            ],
            [
                'id'         => 2,
                'name'       => 'My Profile',
                'location'   => 'footer',
                'is_active'  => 1,
                'sort_order' => 1,
                'created_at' => '2025-08-12 09:26:23',
                'updated_at' => '2025-08-14 05:05:41',
            ],
            [
                'id'         => 3,
                'name'       => 'Useful Links',
                'location'   => 'footer',
                'is_active'  => 1,
                'sort_order' => 2,
                'created_at' => '2025-08-12 09:26:55',
                'updated_at' => '2025-08-12 09:26:55',
            ],
        ];

        foreach ($menus as $menu) {
            $existing = DB::table('menus')
                ->where('name', $menu['name'])
                ->where('location', $menu['location'])
                ->first();

            if ($existing) {
                $this->command->info("Menu '{$menu['name']}' already exists.");
            } else {
                DB::table('menus')->insert(array_merge($menu, [
                    'created_at' => now(),
                    'updated_at' => now(),
                ]));
                $this->command->info("Menu '{$menu['name']}' inserted.");
            }
        }
    }
}