@extends('layout')
@section('title')
    <title>{{ $blog->seo_title }}</title>
    <meta name="title" content="{{ $blog->seo_title }}">
    <meta name="description" content="{{ $blog->seo_description }}">
    @php
        $tags = '';
        if($blog->tags){
            foreach (json_decode($blog->tags) as $blog_tag) {
                $tags .= $blog_tag->value.', ';
            }
        }
    @endphp
     <meta name="keywords" content="{{ $tags }}">
@endsection

@section('body-content')

<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Blog Details') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="{{ route('blogs') }}" class="active">{{ __('translate.Blogs') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <!-- inner-bg  part end  -->

    <section class=" blogs-details footer-top-pad">
        <div class="container">
            <div class="row    justify-content-center">
                <div class="col-lg-9 ">

                    <div class="blogs-details-top-ber">
                        <ul>
                            <li>
                                <a href="javascript:;">
                                    <span>
                                        <svg width="17" height="20" viewBox="0 0 17 20" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0.5184 19.9966C0.108036 19.8303 -0.0123965 19.4927 0.000984899 19.028C0.0366687 17.9127 0.183864 16.8267 0.576386 15.7945C1.20977 14.1264 2.31151 12.9671 3.80131 12.2235C4.87182 11.6903 6.00924 11.4408 7.17343 11.3332C8.26625 11.2305 9.3546 11.25 10.443 11.4066C11.8391 11.6071 13.1683 12.0376 14.337 12.9426C15.6706 13.9748 16.4691 15.4032 16.7902 17.1398C16.9062 17.761 16.924 18.4018 16.9909 19.0378C17.04 19.4976 16.8928 19.84 16.478 20.0064C11.1566 19.9966 5.83975 19.9966 0.5184 19.9966ZM15.6037 18.529C15.6126 18.5095 15.626 18.4948 15.6216 18.485C15.6082 18.3285 15.5993 18.1719 15.5814 18.0203C15.4655 17.0811 15.2067 16.1956 14.7161 15.4081C14.0292 14.3074 13.0568 13.647 11.9238 13.2459C10.8221 12.8546 9.68914 12.7371 8.53833 12.7323C7.32955 12.7274 6.13414 12.8546 4.97888 13.2801C4.17599 13.5736 3.44893 14.0139 2.84231 14.6694C2.10187 15.4717 1.67812 16.4598 1.48186 17.5702C1.42834 17.8833 1.39265 18.2062 1.34805 18.5339C6.12968 18.529 10.8712 18.529 15.6037 18.529Z">
                                            </path>
                                            <path
                                                d="M12.9138 5.09648C12.8603 6.70099 12.2804 8.14407 11.036 9.23494C9.7112 10.3943 7.70845 10.5215 6.3034 9.48442C4.57273 8.20277 3.8992 6.37813 4.14899 4.13769C4.30064 2.79734 4.88943 1.70647 5.88857 0.909102C6.85204 0.14109 7.94039 -0.118175 9.10904 0.048146C10.3714 0.229142 11.3883 0.894427 12.1154 2.04889C12.673 2.92452 12.9049 3.91756 12.9138 5.09648ZM5.41576 4.83232C5.42914 5.9232 5.70123 6.80861 6.2811 7.57662C7.36945 9.01481 9.31868 9.12732 10.5185 7.79675C11.3883 6.83307 11.714 5.65415 11.5266 4.32847C11.1698 1.79452 8.76112 0.811266 6.96355 1.88746C5.88411 2.53318 5.45145 3.61916 5.41576 4.83232Z">
                                            </path>
                                        </svg>
                                    </span>

                                    {{ $blog?->author?->name }}
                                </a>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <span>
                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.9882 3.62212C19.9882 5.86393 19.9882 8.10573 19.9882 10.3475C19.9344 10.2986 19.8855 10.2496 19.8318 10.2056C19.4259 9.84337 19.025 9.47137 18.6094 9.11894C18.4823 9.01126 18.4187 8.92315 18.4236 8.75184C18.4383 8.28683 18.4285 7.81694 18.4285 7.34704C12.7958 7.34704 7.18755 7.34704 1.56464 7.34704C1.56464 7.43025 1.56464 7.50367 1.56464 7.5722C1.56464 10.8811 1.56464 14.1899 1.56464 17.4988C1.56464 18.1351 1.85801 18.4337 2.49364 18.4337C4.513 18.4337 6.52747 18.4435 8.54683 18.4239C8.87931 18.419 9.10912 18.4875 9.24602 18.7959C9.27536 18.8595 9.32914 18.9134 9.37804 18.9672C9.70074 19.3098 10.0283 19.6574 10.351 20C7.59338 20 4.8357 20 2.07314 20C1.99002 19.9804 1.91179 19.9608 1.82867 19.9413C0.728534 19.6769 0.00488949 18.7567 0 17.6114C0 15.4919 0 13.3676 0 11.2433C0 8.80568 0 6.37298 0 3.93539C0 2.79001 0.723644 1.85022 1.82867 1.62017C2.22472 1.53696 2.64032 1.57122 3.05104 1.55164C3.12438 1.54674 3.19773 1.55164 3.29063 1.55164C3.29063 1.01322 3.29063 0.509055 3.29063 0C3.8138 0 4.32231 0 4.84548 0C4.84548 0.518845 4.84548 1.02301 4.84548 1.53696C8.28279 1.53696 11.7054 1.53696 15.1525 1.53696C15.1525 1.01811 15.1525 0.504161 15.1525 0C15.6855 0 16.194 0 16.7172 0C16.7172 0.518845 16.7172 1.0279 16.7172 1.55164C17.0545 1.55164 17.3772 1.54185 17.7048 1.55164C18.4578 1.58101 19.0641 1.89917 19.5286 2.49633C19.7829 2.82917 19.9002 3.22075 19.9882 3.62212ZM15.1525 3.12775C11.7005 3.12775 8.2779 3.12775 4.8357 3.12775C4.8357 3.6466 4.8357 4.15076 4.8357 4.66471C4.31253 4.66471 3.80402 4.66471 3.27107 4.66471C3.27107 4.14097 3.27107 3.63191 3.27107 3.11307C2.95814 3.11307 2.66477 3.10817 2.3714 3.11307C1.88734 3.12286 1.56464 3.44102 1.55975 3.9256C1.55486 4.40039 1.55975 4.87518 1.55975 5.34998C1.55975 5.48213 1.55975 5.61919 1.55975 5.75135C7.19244 5.75135 12.8056 5.75135 18.4236 5.75135C18.4236 5.10524 18.4334 4.47381 18.4187 3.84239C18.4089 3.47528 18.1351 3.15712 17.7684 3.12286C17.4212 3.09349 17.0692 3.11796 16.7025 3.11796C16.7025 3.6417 16.7025 4.15076 16.7025 4.65981C16.1744 4.65981 15.6708 4.65981 15.1525 4.65981C15.1525 4.15076 15.1525 3.6466 15.1525 3.12775Z">
                                            </path>
                                            <path
                                                d="M14.3377 19.9972C13.8292 19.8749 13.2962 19.8112 12.8122 19.6203C11.2084 18.984 10.1181 17.824 9.67311 16.1549C9.10104 14.0354 9.65844 12.1901 11.3013 10.7315C12.4943 9.6693 13.9221 9.26303 15.5014 9.51266C17.3985 9.81124 18.7529 10.8685 19.5401 12.6062C19.7552 13.0761 19.8237 13.6145 19.9606 14.1186C19.9802 14.1872 19.985 14.2557 19.9997 14.3242C19.9997 14.5836 19.9997 14.8431 19.9997 15.1074C19.9313 15.45 19.897 15.8024 19.7944 16.1353C19.3054 17.7897 18.2639 18.9693 16.6602 19.6106C16.1712 19.8063 15.6334 19.87 15.12 19.9972C14.856 19.9972 14.5968 19.9972 14.3377 19.9972ZM14.724 18.4358C16.7629 18.4358 18.4351 16.7618 18.4351 14.7207C18.4302 12.6845 16.7726 11.0203 14.7386 11.0105C12.6997 11.0007 11.0226 12.6698 11.0177 14.7158C11.0128 16.7569 12.685 18.4309 14.724 18.4358Z">
                                            </path>
                                            <path
                                                d="M2.97461 10.5301C2.97461 10.0113 2.97461 9.50713 2.97461 8.98828C3.48831 8.98828 3.99222 8.98828 4.51081 8.98828C4.51081 9.49244 4.51081 10.0064 4.51081 10.5301C4.0069 10.5301 3.49809 10.5301 2.97461 10.5301Z">
                                            </path>
                                            <path
                                                d="M7.64364 8.98828C7.64364 9.50713 7.64364 10.0113 7.64364 10.5252C7.12505 10.5252 6.61625 10.5252 6.09766 10.5252C6.09766 10.0113 6.09766 9.50713 6.09766 8.98828C6.60646 8.98828 7.11527 8.98828 7.64364 8.98828Z">
                                            </path>
                                            <path
                                                d="M10.7725 8.98828C10.7725 9.50713 10.7725 10.0113 10.7725 10.5252C10.2588 10.5252 9.75492 10.5252 9.23633 10.5252C9.23633 10.0211 9.23633 9.51202 9.23633 8.98828C9.74024 8.98828 10.249 8.98828 10.7725 8.98828Z">
                                            </path>
                                            <path
                                                d="M2.97461 13.6502C2.97461 13.1363 2.97461 12.6272 2.97461 12.1133C3.4932 12.1133 4.00201 12.1133 4.5206 12.1133C4.5206 12.6272 4.5206 13.1314 4.5206 13.6502C4.01179 13.6502 3.50299 13.6502 2.97461 13.6502Z">
                                            </path>
                                            <path
                                                d="M6.09766 13.6551C6.09766 13.1363 6.09766 12.6321 6.09766 12.1133C6.61135 12.1133 7.11527 12.1133 7.63386 12.1133C7.63386 12.6174 7.63386 13.1314 7.63386 13.6551C7.12995 13.6551 6.62114 13.6551 6.09766 13.6551Z">
                                            </path>
                                            <path
                                                d="M2.97461 15.2383C3.4932 15.2383 3.99711 15.2383 4.51081 15.2383C4.51081 15.7522 4.51081 16.2564 4.51081 16.7752C4.0069 16.7752 3.49809 16.7752 2.97461 16.7752C2.97461 16.2711 2.97461 15.762 2.97461 15.2383Z">
                                            </path>
                                            <path
                                                d="M7.64364 15.25C7.64364 15.764 7.64364 16.2681 7.64364 16.787C7.12505 16.787 6.61625 16.787 6.09766 16.787C6.09766 16.2779 6.09766 15.7688 6.09766 15.25C6.60157 15.25 7.11038 15.25 7.64364 15.25Z">
                                            </path>
                                            <path
                                                d="M13.9219 12.1133C14.4402 12.1133 14.9438 12.1133 15.467 12.1133C15.467 12.7202 15.467 13.3174 15.467 13.9341C15.9119 13.9341 16.3422 13.9341 16.7871 13.9341C16.7871 14.4628 16.7871 14.9669 16.7871 15.4858C15.8434 15.4858 14.89 15.4858 13.9219 15.4858C13.9219 14.3698 13.9219 13.2489 13.9219 12.1133Z">
                                            </path>
                                        </svg>
                                    </span>

                                    {{ $blog->created_at->diffForHumans() }}
                                </a>
                            </li>
                            <li>
                                <a href="javascript:;">
                                    <span>
                                        <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M8.50485 16.9537C7.11942 16.9442 5.80965 16.6281 4.58026 15.9865C4.44313 15.9157 4.32965 15.9063 4.18307 15.9488C3.05771 16.2743 1.93234 16.5951 0.802251 16.9159C0.423977 17.0244 0.0977163 16.8688 0.02679 16.5243C0.00314794 16.4017 0.02679 16.2554 0.059889 16.128C0.376693 15.0005 0.698226 13.8776 1.02449 12.7547C1.05759 12.6321 1.04813 12.5377 0.986659 12.4245C-1.61397 7.54614 1.16161 1.47418 6.55674 0.223927C11.2662 -0.865913 15.9001 2.12997 16.8411 6.87148C17.73 11.3394 14.7984 15.7931 10.3442 16.7414C9.74369 16.8688 9.12427 16.9159 8.50958 17.0009C8.50958 16.9867 8.50485 16.9678 8.50485 16.9537ZM1.40276 15.5572C1.48314 15.5383 1.53043 15.5289 1.57298 15.5194C2.4241 15.2788 3.27521 15.0476 4.1216 14.7929C4.41476 14.7032 4.66064 14.741 4.92543 14.8872C6.51891 15.7742 8.21641 16.0431 9.99903 15.6751C14.0135 14.8448 16.5573 10.9289 15.692 6.92809C14.7795 2.71027 10.4009 0.181466 6.28722 1.48833C3.28467 2.44607 1.25618 5.12585 1.15688 8.31044C1.11433 9.65505 1.44059 10.9242 2.1073 12.0942C2.24442 12.3348 2.27279 12.5566 2.19241 12.8161C2.08365 13.1558 1.98908 13.5049 1.88979 13.8493C1.72902 14.406 1.57298 14.9627 1.40276 15.5572Z">
                                            </path>
                                            <path
                                                d="M8.47806 6.21871C7.36216 6.21871 6.24625 6.21871 5.13507 6.21871C4.70478 6.21871 4.42108 5.83184 4.57239 5.45441C4.66223 5.23267 4.83245 5.11 5.0736 5.09585C5.14926 5.09113 5.22491 5.09585 5.30529 5.09585C7.46618 5.09585 9.62234 5.09585 11.7832 5.09585C11.8589 5.09585 11.9393 5.09113 12.0102 5.11C12.2939 5.16662 12.4878 5.43554 12.4594 5.71861C12.431 6.00169 12.1946 6.22343 11.8967 6.22343C11.126 6.22815 10.3505 6.22343 9.57978 6.22343C9.21097 6.21871 8.84688 6.21871 8.47806 6.21871Z">
                                            </path>
                                            <path
                                                d="M8.49268 9.04374C7.37204 9.04374 6.25141 9.04374 5.13077 9.04374C4.70049 9.04374 4.42151 8.65216 4.57282 8.27C4.65793 8.05298 4.86125 7.91616 5.11186 7.91616C5.44285 7.91144 5.77384 7.91616 6.10483 7.91616C8.01511 7.91616 9.92539 7.91616 11.8357 7.91616C12.2849 7.91616 12.5686 8.29359 12.422 8.68046C12.3369 8.91164 12.1288 9.04374 11.8499 9.04374C10.734 9.04374 9.61332 9.04374 8.49268 9.04374Z">
                                            </path>
                                            <path
                                                d="M8.5004 10.7383C9.62104 10.7383 10.7417 10.7383 11.8623 10.7383C12.302 10.7383 12.5858 11.1393 12.4203 11.5215C12.3162 11.7621 12.1176 11.8706 11.8576 11.8706C10.8788 11.8706 9.90001 11.8706 8.92123 11.8706C7.66347 11.8706 6.41044 11.8706 5.15268 11.8706C4.70821 11.8706 4.42923 11.479 4.58054 11.0968C4.67038 10.8704 4.8737 10.743 5.15741 10.743C6.27331 10.7383 7.38449 10.7383 8.5004 10.7383Z">
                                            </path>
                                        </svg>
                                    </span>

                                    {{ $blog->total_comment }} {{ __('translate.Comments') }}
                                </a>
                            </li>

                            <li>
                                <a href="javascript:;">
                                    <span>
                                        <svg width="24" height="17" viewBox="0 0 24 17" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M12.0003 13.2228C6.16787 13.2228 6.16787 3.77832 12.0003 3.77832C17.7664 3.77832 18.0156 13.2228 12.0003 13.2228ZM12.0003 5.66721C8.46549 5.66721 8.46549 11.3339 12.0003 11.3339C15.5351 11.3339 15.5351 5.66721 12.0003 5.66721Z">
                                            </path>
                                            <path
                                                d="M12 17C7.62656 17 3.4387 14.5171 0.511886 10.1868C0.17916 9.69624 0 9.10587 0 8.5C0 7.89413 0.17916 7.30376 0.511886 6.81322C3.4387 2.48294 7.62656 0 12 0C16.3734 0 20.5613 2.48294 23.4881 6.81322C23.8208 7.30376 24 7.89413 24 8.5C24 9.10587 23.8208 9.69624 23.4881 10.1868C20.5613 14.5171 16.3734 17 12 17ZM1.94083 9.07989C4.57249 12.9691 8.14441 15.1111 12 15.1111C15.8556 15.1111 19.4275 12.9691 22.0592 9.07989C22.1736 8.91111 22.2353 8.70799 22.2353 8.49953C22.2353 8.29107 22.1736 8.08794 22.0592 7.91917C19.4275 4.03089 15.8556 1.88889 12 1.88889C8.14441 1.88889 4.57249 4.03089 1.94083 7.92011C1.82635 8.08889 1.76471 8.29201 1.76471 8.50047C1.76471 8.70893 1.82635 8.91111 1.94083 9.07989Z">
                                            </path>
                                        </svg>
                                    </span>
                                    {{ $blog->views }}+ {{ __('translate.Views') }}
                                </a>
                            </li>
                        </ul>
                    </div>


                    <h2 class="blogs-details">{{ $blog->title }}</h2>

                    <div class="blogs-details-dec">
                        {!! clean($blog->description) !!}
                    </div>


                    <div class="row tag-top  ">
                        @if ($blog->tags)
                            <div class="col-lg-8 col-md-8">
                                <div class="tag">
                                    <h6>{{ __('translate.Tag') }}:</h6>
                                    <ul>
                                        @foreach (json_decode($blog->tags) as $blog_tag)
                                            <li><a href="javascript:;">#{{ $blog_tag->value }}</a></li>
                                        @endforeach
                                    </ul>
                                </div>
                            </div>
                        @endif

                        <div class="col-lg-4 col-md-4 ">
                            <div class="share">
                                <h6>
                                    {{ __('translate.Share') }}:
                                </h6>

                                <ul>
                                    <li>
                                        <a href="https://twitter.com/share?text={{ $blog->title }}&url={{ route('blog', $blog->slug) }}" target="_blank">
                                            <span>
                                            <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M16.4803 1.5837C15.8742 1.85217 15.2221 2.03376 14.5382 2.11486C15.2365 1.69703 15.7723 1.03591 16.0252 0.246849C15.3719 0.63395 14.6479 0.914769 13.8781 1.06613C13.2613 0.410051 12.3826 3.05176e-05 11.4095 3.05176e-05C9.54255 3.05176e-05 8.02836 1.51242 8.02836 3.37716C8.02836 3.64186 8.05836 3.89951 8.11636 4.14683C5.30635 4.00604 2.8148 2.66164 1.14705 0.617831C0.856066 1.1165 0.689139 1.69703 0.689139 2.31584C0.689139 3.48722 1.28649 4.52134 2.19324 5.1268C1.63926 5.10942 1.11755 4.95755 0.661906 4.70393C0.661654 4.71829 0.661654 4.73264 0.661654 4.74675C0.661654 6.38305 1.82762 7.74786 3.37408 8.05789C3.09066 8.13546 2.79135 8.17651 2.48347 8.17651C2.26511 8.17651 2.05355 8.15561 1.84729 8.11632C2.27746 9.4577 3.52588 10.4341 5.00578 10.4616C3.84839 11.3675 2.39068 11.9072 0.806139 11.9072C0.533811 11.9072 0.264006 11.8914 0 11.8599C1.49553 12.8185 3.27322 13.3773 5.18254 13.3773C11.4017 13.3773 14.8028 8.23142 14.8028 3.76829C14.8028 3.62196 14.7995 3.47614 14.7929 3.33157C15.4541 2.85557 16.0272 2.26094 16.4803 1.5837Z"></path>
                                            </svg>
                                            </span>
                                        </a>
                                    </li>

                                    <li><a href="https://www.linkedin.com/shareArticle?mini=true&url={{ route('blog', $blog->slug) }}&title={{ $blog->title }}" target="_blank">
                                            <span>
                                            <svg width="16" height="15" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M15.1381 8.85755V14.4483H11.8928V9.23223C11.8928 7.92253 11.4242 7.02812 10.2492 7.02812C9.35251 7.02812 8.81982 7.63027 8.58457 8.21333C8.49914 8.4217 8.47711 8.71106 8.47711 9.00331V14.4481H5.23158C5.23158 14.4481 5.27514 5.61375 5.23158 4.69927H8.47735V6.08077C8.47082 6.09165 8.46162 6.10229 8.45581 6.11268H8.47735V6.08077C8.90864 5.41794 9.67779 4.47035 11.4022 4.47035C13.5373 4.47035 15.1381 5.8637 15.1381 8.85755ZM1.83647 0C0.726312 0 0 0.727856 0 1.68415C0 2.62013 0.705256 3.36902 1.79388 3.36902H1.81493C2.94688 3.36902 3.65068 2.62013 3.65068 1.68415C3.62914 0.727856 2.94688 0 1.83647 0ZM0.192892 14.4483H3.43722V4.69927H0.192892V14.4483Z"></path>
                                            </svg>
                                            </span>
                                        </a></li>

                                    <li><a href="https://www.facebook.com/sharer/sharer.php?u={{ route('blog', $blog->slug) }}&t={{ $blog->title }}" target="_blank">
                                            <span>
                                            <svg width="9" height="19" viewBox="0 0 9 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.02329 9.03851H5.54365V18.1119H1.78678V9.03851H0V5.84976H1.78678V3.78627C1.78678 2.31066 2.48856 0 5.57709 0L8.35994 0.0116285V3.10686H6.3408C6.0096 3.10686 5.5439 3.27213 5.5439 3.97605V5.85273H8.35152L8.02329 9.03851Z"></path>
                                            </svg>
                                            </span>
                                        </a></li>
                                    <li><a href="https://www.instagram.com/?url={{ route('blog', $blog->slug) }}" target="_blank">

                                            <span>
                                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_3008_180233)">
<path d="M18.9772 4.44092C18.656 4.44092 18.3945 4.70234 18.3945 5.02357C18.3945 5.34481 18.656 5.60623 18.9772 5.60623C19.2985 5.60623 19.5598 5.34486 19.5598 5.02357C19.5598 4.70229 19.2985 4.44092 18.9772 4.44092Z" />
<path d="M11.9994 6.83447C9.1512 6.83447 6.83398 9.15169 6.83398 11.9999C6.83398 14.8481 9.1512 17.1654 11.9994 17.1654C14.8477 17.1654 17.1649 14.8482 17.1649 12C17.1649 9.15174 14.8477 6.83447 11.9994 6.83447Z" />
<path d="M17.4208 0H6.57923C2.95144 0 0 2.95144 0 6.57928V17.4208C0 21.0486 2.95144 24 6.57923 24H17.4208C21.0486 24 24 21.0486 24 17.4208V6.57928C24 2.95144 21.0486 0 17.4208 0ZM12 18.5828C8.37023 18.5828 5.4173 15.6298 5.4173 12C5.4173 8.37023 8.37028 5.41734 12 5.41734C15.6297 5.41734 18.5828 8.37028 18.5828 12C18.5828 15.6297 15.6297 18.5828 12 18.5828ZM18.9765 7.02356C17.8737 7.02356 16.9765 6.12637 16.9765 5.02359C16.9765 3.92081 17.8737 3.02358 18.9765 3.02358C20.0792 3.02358 20.9764 3.92077 20.9764 5.02355C20.9764 6.12633 20.0792 7.02356 18.9765 7.02356Z" />
</g>

</svg>
                                            </span>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="blog-details-prot">
                                <div class="blog-details-prot-item">
                                    <div class="blog-details-prot-item-inner">
                                        <div class="blog-details-prot-item-img">
                                            <img src="{{ custom_asset($blog?->author?->image, '120x120') }}" alt="thumb">
                                        </div>
                                        <div class="blog-details-prot-item-text">
                                            <h6>{{ $blog?->author?->name }}</h6>
                                            <a href="javascript:;">{{ $blog?->author?->designation }}</a>
                                            <p>
                                                {{ $blog?->author?->about_me }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="share">

                                        <ul>
                                            @if ($blog->author->twitter)
                                            <li>
                                                <a href="{{ $blog->author->twitter }}" target="_blank">
                                                    <span>
                                                    <svg width="14" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M16.4803 1.5837C15.8742 1.85217 15.2221 2.03376 14.5382 2.11486C15.2365 1.69703 15.7723 1.03591 16.0252 0.246849C15.3719 0.63395 14.6479 0.914769 13.8781 1.06613C13.2613 0.410051 12.3826 3.05176e-05 11.4095 3.05176e-05C9.54255 3.05176e-05 8.02836 1.51242 8.02836 3.37716C8.02836 3.64186 8.05836 3.89951 8.11636 4.14683C5.30635 4.00604 2.8148 2.66164 1.14705 0.617831C0.856066 1.1165 0.689139 1.69703 0.689139 2.31584C0.689139 3.48722 1.28649 4.52134 2.19324 5.1268C1.63926 5.10942 1.11755 4.95755 0.661906 4.70393C0.661654 4.71829 0.661654 4.73264 0.661654 4.74675C0.661654 6.38305 1.82762 7.74786 3.37408 8.05789C3.09066 8.13546 2.79135 8.17651 2.48347 8.17651C2.26511 8.17651 2.05355 8.15561 1.84729 8.11632C2.27746 9.4577 3.52588 10.4341 5.00578 10.4616C3.84839 11.3675 2.39068 11.9072 0.806139 11.9072C0.533811 11.9072 0.264006 11.8914 0 11.8599C1.49553 12.8185 3.27322 13.3773 5.18254 13.3773C11.4017 13.3773 14.8028 8.23142 14.8028 3.76829C14.8028 3.62196 14.7995 3.47614 14.7929 3.33157C15.4541 2.85557 16.0272 2.26094 16.4803 1.5837Z"></path>
                                            </svg>
                                                    </span>
                                                </a>
                                            </li>
                                            @endif

                                            @if ($blog->author->linkedin)
                                            <li>
                                                <a href="{{ $blog->author->linkedin }}" target="_blank">
                                                    <span>
                                                    <svg width="14" height="14" viewBox="0 0 16 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M15.1381 8.85755V14.4483H11.8928V9.23223C11.8928 7.92253 11.4242 7.02812 10.2492 7.02812C9.35251 7.02812 8.81982 7.63027 8.58457 8.21333C8.49914 8.4217 8.47711 8.71106 8.47711 9.00331V14.4481H5.23158C5.23158 14.4481 5.27514 5.61375 5.23158 4.69927H8.47735V6.08077C8.47082 6.09165 8.46162 6.10229 8.45581 6.11268H8.47735V6.08077C8.90864 5.41794 9.67779 4.47035 11.4022 4.47035C13.5373 4.47035 15.1381 5.8637 15.1381 8.85755ZM1.83647 0C0.726312 0 0 0.727856 0 1.68415C0 2.62013 0.705256 3.36902 1.79388 3.36902H1.81493C2.94688 3.36902 3.65068 2.62013 3.65068 1.68415C3.62914 0.727856 2.94688 0 1.83647 0ZM0.192892 14.4483H3.43722V4.69927H0.192892V14.4483Z"></path>
                                            </svg>
                                                    </span>
                                                </a>
                                            </li>
                                            @endif

                                            @if ($blog->author->facebook)
                                            <li>
                                                <a href="{{ $blog->author->facebook }}" target="_blank">
                                                    <span>
                                                    <svg width="13" height="14" viewBox="0 0 9 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.02329 9.03851H5.54365V18.1119H1.78678V9.03851H0V5.84976H1.78678V3.78627C1.78678 2.31066 2.48856 0 5.57709 0L8.35994 0.0116285V3.10686H6.3408C6.0096 3.10686 5.5439 3.27213 5.5439 3.97605V5.85273H8.35152L8.02329 9.03851Z"></path>
                                            </svg>
                                                    </span>
                                                </a>
                                            </li>
                                            @endif



                                            @if ($blog->author->instagram)
                                            <li>
                                                <a href="{{ $blog->author->instagram }}" target="_blank"><span>
                                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_3008_180233)">
<path d="M18.9772 4.44092C18.656 4.44092 18.3945 4.70234 18.3945 5.02357C18.3945 5.34481 18.656 5.60623 18.9772 5.60623C19.2985 5.60623 19.5598 5.34486 19.5598 5.02357C19.5598 4.70229 19.2985 4.44092 18.9772 4.44092Z"></path>
<path d="M11.9994 6.83447C9.1512 6.83447 6.83398 9.15169 6.83398 11.9999C6.83398 14.8481 9.1512 17.1654 11.9994 17.1654C14.8477 17.1654 17.1649 14.8482 17.1649 12C17.1649 9.15174 14.8477 6.83447 11.9994 6.83447Z"></path>
<path d="M17.4208 0H6.57923C2.95144 0 0 2.95144 0 6.57928V17.4208C0 21.0486 2.95144 24 6.57923 24H17.4208C21.0486 24 24 21.0486 24 17.4208V6.57928C24 2.95144 21.0486 0 17.4208 0ZM12 18.5828C8.37023 18.5828 5.4173 15.6298 5.4173 12C5.4173 8.37023 8.37028 5.41734 12 5.41734C15.6297 5.41734 18.5828 8.37028 18.5828 12C18.5828 15.6297 15.6297 18.5828 12 18.5828ZM18.9765 7.02356C17.8737 7.02356 16.9765 6.12637 16.9765 5.02359C16.9765 3.92081 17.8737 3.02358 18.9765 3.02358C20.0792 3.02358 20.9764 3.92077 20.9764 5.02355C20.9764 6.12633 20.0792 7.02356 18.9765 7.02356Z"></path>
</g>

</svg>
                                                    </span></a>
                                            </li>
                                            @endif

                                        </ul>

                                        <h6>
                                            {{ __('translate.Social Profile') }}
                                        </h6>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                    @if ($blog->total_comment > 0)
                        <div class="row">

                            <h3 class="write-your-review-text">{{ $blog->total_comment }} {{ __('translate.Comments') }}</h3>
                            @foreach ($blog_comments as $blog_comment)
                                <div class="col-lg-12">
                                    <div class="blog-details-comment-item">
                                        <div class="blog-details-comment-inner">
                                            <div class="blog-details-comment-inner-img">
                                                <img src="{{ custom_asset($setting->default_avatar, '120x120') }}" alt="img">
                                            </div>

                                            <div class="blog-details-comment-inner-text">
                                                <div class="blog-details-comment-inner-text-item">
                                                    <h3>{{ html_decode($blog_comment->name) }}</h3>

                                                    <span>{{ $blog_comment->created_at->diffForHumans() }}</span>
                                                </div>

                                                <div class="blog-details-comment-text">
                                                    <p>{{ html_decode($blog_comment->comment) }}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    @endif

                    <div class="row gy-5">
                        <div class="col-lg-12">
                            <div class="write-your-review-item">


                                <h3 class="write-your-review-text">{{ __('translate.Drop your comment') }}</h3>

                                <form action="{{ route('store-comment') }}" method="POST" id="review_form">
                                    @csrf
                                    <input type="hidden" name="blog_id" value="{{ $blog->id }}">

                                    <div class="form-item">
                                        <div class="form-inner">
                                            <label for="exampleFormControlInput1" class="form-label">{{ __('translate.Name') }}
                                                <span>*</span></label>
                                            <input type="text" class="form-control" id="exampleFormControlInput1"
                                                placeholder="{{ __('translate.Name Here') }}" value="{{ old('name') }}" name="name">
                                        </div>
                                        <div class="form-inner">
                                            <label for="exampleFormControlInput2" class="form-label">{{ __('translate.Email') }}
                                                <span>*</span></label>
                                            <input type="email" class="form-control" id="exampleFormControlInput2"
                                                placeholder="{{ __('translate.Email Address') }}" name="email" value="{{ old('email') }}">
                                        </div>
                                    </div>

                                    <div class="form-item two">
                                        <div class="form-inner">
                                            <label for="exampleFormControlTextarea3" class="form-label">{{ __('translate.Comment') }} <span>*</span> </label>
                                            <textarea class="form-control" id="exampleFormControlTextarea3" rows="5"
                                                placeholder="{{ __('translate.Comment here') }}" name="comment">{{ old('comment') }}</textarea>
                                        </div>

                                    </div>

                                    @if($google_recaptcha->status==1)
                                        <div class="form-item two">
                                            <div class="form-inner">
                                                <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                            </div>
                                        </div>
                                    @endif

                                    <a class="main-btn " href="javascript:;" id="review_form_btn">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Submit comment') }}</div>
                                                <div class="btn_t2">{{ __('translate.Submit comment') }}</div>
                                            </div>
                                        </div>
                                    </a>

                                </form>

                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>

</main>
@endsection

@push('js_section')
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script>
    (function($) {
        "use strict"
        $(document).ready(function () {

            $('#review_form_btn').on("click", function(){
                $("#review_form").submit();
            });

        });
    })(jQuery);

</script>
@endpush
