@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')

<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Contact Us') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Contact Us') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->



    <!-- contact-us part start  -->
    <section class="contact-us ">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="contuct-us-form-main">
                        <h2 class="taitel">{{ $contact_us->title }}</h2>
                        <p class="contuct-us-dec">{{ $contact_us->description }}</p>


                        <form class="contuct-us-form" action="{{ route('store-contact-message') }}" method="POST">
                            @csrf
                            <div class="contuct-us-form-item">
                                <div class="contuct-us-form-inner">
                                    <label for="exampleFormControlInput8" class="form-label">{{ __('translate.Name') }}
                                        <span>*</span></label>
                                    <input type="text" class="form-control" id="exampleFormControlInput8"
                                        placeholder="{{ __('translate.Name Here') }}" name="name" value="{{ old('name') }}">
                                </div>
                                <div class="contuct-us-form-inner">
                                    <label for="exampleFormControlInput4" class="form-label">{{ __('translate.Phone') }}
                                        </label>
                                    <input type="text" class="form-control" id="exampleFormControlInput4"
                                        placeholder="{{ __('translate.Phone Number') }}" name="phone" value="{{ old('phone') }}">
                                </div>
                            </div>
                            <div class="contuct-us-form-item two">
                                <div class="contuct-us-form-inner">
                                    <label for="exampleFormControlInput5" class="form-label">{{ __('translate.Email') }}
                                        <span>*</span></label>
                                    <input type="text" class="form-control" id="exampleFormControlInput5"
                                        placeholder="{{ __('translate.Email Address') }}" name="email" value="{{ old('email') }}">
                                </div>
                                <div class="contuct-us-form-inner">
                                    <label for="exampleFormControlInput6" class="form-label">{{ __('translate.Subject') }}
                                        <span>*</span></label>
                                    <input type="text" class="form-control" id="exampleFormControlInput6"
                                        placeholder="{{ __('translate.Subject') }}" name="subject" value="{{ old('subject') }}">
                                </div>
                            </div>

                            <div class="contuct-us-form-item three">
                                <div class="contuct-us-form-inner">
                                    <label class="form-label">{{ __('translate.Message') }}
                                        <span>*</span></label>
                                    <textarea class="form-control" id="exampleFormControlTextarea1" rows="5"
                                        placeholder="{{ __('translate.Message here') }}" name="message">{{ old('message') }}</textarea>
                                </div>
                            </div>

                            @if($google_recaptcha->status==1)
                                <div class="contuct-us-form-item three">
                                    <div class="contuct-us-form-inner">
                                        <div class="g-recaptcha" data-sitekey="{{ $google_recaptcha->site_key }}"></div>
                                    </div>
                                </div>
                            @endif

                            <div class="contuct-us-form-item ">
                                <a class="main-btn " href="javascript:;" id="contact_message_btn">
                                    <div class="btn_m">
                                        <div class="btn_c">
                                            <div class="btn_t1">{{ __('translate.Send Message') }}</div>
                                            <div class="btn_t2">{{ __('translate.Send Message') }}</div>
                                        </div>
                                    </div>
                                </a>
                            </div>

                        </form>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="contact-details-main">
                        <h2 class="taitel">{{ __('translate.Contact Details') }}</h2>
                        <p class="contact-details-dec">{{ $contact_us->contact_description }}</p>


                        <div class="contact">
                            <div class="contact-item">
                                <div class="icon">
                                    <span>
                                        <svg width="21" height="21" viewBox="0 0 21 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M21 18.6667V16.7464C21 15.7923 20.4191 14.9343 19.5332 14.58L17.1601 13.6307C16.0333 13.18 14.7492 13.6682 14.2065 14.7536L14 15.1667C14 15.1667 11.0833 14.5833 8.75 12.25C6.41667 9.91667 5.83333 7 5.83333 7L6.24635 6.79349C7.33178 6.25078 7.82 4.96666 7.3693 3.83992L6.42004 1.46676C6.06569 0.580886 5.2077 0 4.25359 0H2.33333C1.04467 0 0 1.04467 0 2.33333C0 12.6426 8.35735 21 18.6667 21C19.9553 21 21 19.9553 21 18.6667Z" />
                                        </svg>
                                    </span>
                                </div>

                                <div class="text">
                                    <p>{{ __('translate.Phone') }}</p>

                                    <a href="tel:{{ $contact_us->phone }}">{{ $contact_us->phone }}</a>
                                    <a href="tel:{{ $contact_us->phone2 }}">{{ $contact_us->phone2 }}</a>
                                </div>
                            </div>
                            <div class="contact-item ">
                                <div class="icon">
                                    <span>
                                        <svg width="24" height="21" viewBox="0 0 24 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M5.33116 0C2.87656 0 0.886719 2.08934 0.886719 4.66667V16.3333C0.886719 18.9107 2.87656 21 5.33116 21H18.6645C21.1191 21 23.1089 18.9107 23.1089 16.3333V4.66667C23.1089 2.08934 21.1191 0 18.6645 0H5.33116ZM5.79342 5.10524C5.41048 4.83718 4.89309 4.94583 4.63779 5.34792C4.3825 5.75001 4.48598 6.29327 4.86892 6.56133L9.07025 9.50226C10.8431 10.7432 13.1526 10.7432 14.9254 9.50226L19.1267 6.56133C19.5097 6.29327 19.6132 5.75001 19.3579 5.34792C19.1026 4.94583 18.5852 4.83718 18.2023 5.10524L14.0009 8.04617C12.7879 8.89525 11.2077 8.89525 9.99475 8.04617L5.79342 5.10524Z" />
                                        </svg>
                                    </span>
                                </div>

                                <div class="text">
                                    <p>{{ __('translate.Email') }}</p>

                                    <a href="mailto:{{ $contact_us->email }}">{{ $contact_us->email }}</a>
                                    <a href="mailto:{{ $contact_us->email2 }}">{{ $contact_us->email2 }}</a>
                                </div>
                            </div>

                            <div class="contact-item  ">
                                <div class="icon">
                                    <span>
                                        <svg width="19" height="21" viewBox="0 0 19 21" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M9.5 21C13.0625 21 19 14.488 19 9.33333C19 4.17868 14.7467 0 9.5 0C4.25329 0 0 4.17868 0 9.33333C0 14.488 5.9375 21 9.5 21ZM9.4987 12.6C11.2476 12.6 12.6654 11.1897 12.6654 9.45005C12.6654 7.71035 11.2476 6.30005 9.4987 6.30005C7.7498 6.30005 6.33203 7.71035 6.33203 9.45005C6.33203 11.1897 7.7498 12.6 9.4987 12.6Z" />
                                        </svg>

                                    </span>
                                </div>

                                <div class="text">
                                    <p>{{ __('translate.Location') }}</p>

                                    <a href="javascript:;">{{ $contact_us->address }}</a>

                                </div>
                            </div>

                        </div>

                        <ul class="follow">
                            <li>{{ __('translate.Follow Us') }}</li>
                            <li>
                                <a href="{{ $setting->facebook }}" target="_blank">
                                    <span>
                                        <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_423_120014)">
                                                <path
                                                    d="M7.74461 13.009H5.79193C5.46577 13.009 5.20045 12.7437 5.20045 12.4175V8.01311H4.06121C3.73505 8.01311 3.46973 7.7477 3.46973 7.42163V5.53435C3.46973 5.20818 3.73505 4.94286 4.06121 4.94286H5.20045V3.99778C5.20045 3.06069 5.4947 2.26343 6.05129 1.69232C6.6104 1.11861 7.39175 0.81543 8.31088 0.81543L9.8001 0.817848C10.1257 0.818407 10.3906 1.08373 10.3906 1.40933V3.16163C10.3906 3.48779 10.1253 3.75311 9.79926 3.75311L8.79659 3.75348C8.4908 3.75348 8.41294 3.81479 8.39628 3.83358C8.36884 3.86475 8.33619 3.95285 8.33619 4.19612V4.94277H9.72391C9.82838 4.94277 9.9296 4.96854 10.0166 5.0171C10.2042 5.12195 10.3209 5.32019 10.3209 5.53444L10.3201 7.42173C10.3201 7.7477 10.0548 8.01302 9.72865 8.01302H8.33619V12.4175C8.33619 12.7437 8.07078 13.009 7.74461 13.009ZM5.91528 12.2941H7.62126V7.69309C7.62126 7.47531 7.79848 7.29818 8.01617 7.29818H9.60529L9.60595 5.6577H8.01607C7.79838 5.6577 7.62126 5.48058 7.62126 5.26279V4.19612C7.62126 3.91684 7.64963 3.59924 7.86044 3.36053C8.11515 3.07195 8.51657 3.03865 8.7964 3.03865L9.67572 3.03827V1.5325L8.31033 1.53027C6.8332 1.53027 5.91528 2.47582 5.91528 3.99778V5.26279C5.91528 5.48048 5.73816 5.6577 5.52047 5.6577H4.18456V7.29818H5.52047C5.73816 7.29818 5.91528 7.47531 5.91528 7.69309V12.2941Z">
                                                </path>
                                            </g>

                                        </svg>
                                    </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ $setting->twitter }}" target="_blank">
                                    <span>
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_423_120005)">
                                                <path
                                                    d="M1.20739 10.9229C2.33631 11.6393 3.65016 12.0178 5.00669 12.0178C6.99323 12.0178 8.81362 11.2547 10.1331 9.86918C11.3956 8.54313 12.0901 6.76135 12.0556 4.95315C12.5342 4.54365 13.0971 3.76174 13.0971 2.99964C13.0971 2.7075 12.7801 2.52206 12.523 2.67092C12.0734 2.93512 11.6634 3.00421 11.2417 2.88584C10.3805 2.04651 9.09865 1.86971 8.0185 2.45195C7.07452 2.96001 6.54969 3.88977 6.59693 4.9059C5.00212 4.71131 3.52873 3.91162 2.50143 2.66889C2.33275 2.46617 2.01267 2.49005 1.87854 2.7197C1.38368 3.56715 1.38877 4.54924 1.8191 5.34233C1.61435 5.3784 1.48784 5.55063 1.48784 5.73709C1.48784 6.53425 1.84653 7.26688 2.4242 7.76681C2.31649 7.87046 2.28093 8.0244 2.32665 8.16158C2.58068 8.92469 3.15581 9.52116 3.87473 9.8199C3.09281 10.1933 2.22809 10.3178 1.45837 10.2233C1.06005 10.1694 0.863426 10.7049 1.20739 10.9229ZM5.11085 9.95047C5.39587 9.7315 5.24447 9.27525 4.88679 9.26763C4.25679 9.25442 3.68318 8.944 3.32602 8.45575C3.49825 8.44457 3.67658 8.41815 3.84627 8.37242C4.23291 8.26776 4.21462 7.70991 3.82189 7.63116C3.10907 7.48788 2.54969 6.96864 2.33986 6.30003C2.5314 6.34728 2.7265 6.3737 2.92109 6.37725C3.30671 6.37929 3.45252 5.88494 3.13803 5.67816C2.42928 5.21125 2.12698 4.38666 2.32716 3.61135C3.56481 4.86525 5.24396 5.62075 7.02015 5.7061C7.27469 5.72185 7.46572 5.48255 7.40984 5.24021C7.16851 4.1941 7.75278 3.46096 8.38024 3.1231C9.0011 2.78778 9.99792 2.68312 10.762 3.48484C10.9892 3.72414 11.7553 3.73329 12.145 3.64234C11.9702 3.97157 11.7015 4.28403 11.45 4.45982C11.3428 4.53501 11.2813 4.66 11.2879 4.79057C11.3697 6.45956 10.7478 8.1189 9.58181 9.34283C8.40717 10.5759 6.78289 11.2552 5.0072 11.2552C4.30099 11.2552 3.6085 11.1404 2.95411 10.9188C3.73653 10.7674 4.47983 10.4362 5.11085 9.95047Z">
                                                </path>
                                            </g>
                                        </svg>
                                    </span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ $setting->linkedin }}" target="_blank">
                                    <span>
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_423_120018)">
                                                <path
                                                    d="M2.61293 1.06934C2.16584 1.06934 1.75938 1.23192 1.45454 1.53676C1.12939 1.86192 0.966797 2.26835 0.966797 2.69513C0.966797 3.14222 1.1497 3.54867 1.45454 3.85351C1.75938 4.15835 2.18615 4.34126 2.59261 4.32094C2.59261 4.32094 2.61293 4.32094 2.63326 4.32094C3.03972 4.32094 3.42584 4.15835 3.73068 3.85351C4.03552 3.54867 4.21843 3.14222 4.21843 2.69513C4.23874 2.26835 4.05584 1.86189 3.751 1.55705C3.44616 1.2319 3.0397 1.06934 2.61293 1.06934ZM3.44616 3.56901C3.2226 3.79257 2.91776 3.93482 2.59261 3.91451C2.28777 3.91451 1.96262 3.79257 1.73906 3.56901C1.49519 3.34546 1.37326 3.0203 1.37326 2.69515C1.37326 2.37 1.49519 2.06516 1.73906 1.82129C1.96262 1.59773 2.26746 1.4758 2.61293 1.4758C2.91776 1.4758 3.2226 1.59773 3.44616 1.82129C3.69003 2.06516 3.81197 2.37 3.81197 2.69515C3.81197 3.0203 3.69003 3.34546 3.44616 3.56901Z">
                                                </path>
                                                <path
                                                    d="M3.40541 4.72754H1.75928C1.43413 4.72754 1.16992 4.99172 1.16992 5.33722V12.4501C1.16992 12.7753 1.45445 13.0598 1.7796 13.0598H3.40541C3.73057 13.0598 4.01509 12.7753 4.01509 12.4704V5.33722C4.01509 5.01204 3.73057 4.72754 3.40541 4.72754ZM3.60863 12.4704C3.60863 12.5721 3.50701 12.6533 3.40541 12.6533H1.7796C1.67798 12.6533 1.57638 12.5517 1.57638 12.4501V5.33722C1.57638 5.2356 1.65766 5.134 1.75928 5.134H3.40541C3.50703 5.134 3.60863 5.23562 3.60863 5.33722V12.4704Z">
                                                </path>
                                                <path
                                                    d="M10.3149 4.52441H9.88816C9.09558 4.52441 8.34365 4.86991 7.85591 5.41862V5.13409C7.85591 4.93087 7.65269 4.72763 7.44945 4.72763H5.4172C5.2343 4.72763 5.01074 4.89022 5.01074 5.11375V12.6941C5.01074 12.9176 5.2343 13.0599 5.4172 13.0599H7.65269C7.8356 13.0599 8.05915 12.9176 8.05915 12.6941V8.30439C8.05915 7.63375 8.5469 7.10535 9.17689 7.10535C9.50204 7.10535 9.80688 7.22729 10.0304 7.45084C10.2337 7.63375 10.315 7.91827 10.315 8.28408V12.6534C10.315 12.8567 10.5182 13.0599 10.7214 13.0599H12.7537C12.9569 13.0599 13.1601 12.8567 13.1601 12.6534V7.41021C13.1601 5.78442 11.9204 4.52441 10.3149 4.52441ZM12.7536 12.6331L12.7333 12.6534H10.7417L10.7214 8.2841C10.7214 7.79636 10.5995 7.43055 10.3353 7.16637C10.0304 6.86153 9.62398 6.69894 9.1972 6.69894C8.34365 6.71925 7.67301 7.41024 7.67301 8.30441V12.6534H5.43752V5.13409H7.44945L7.46977 5.15441V6.43473L8.01848 5.88602L8.03879 5.8657C8.44525 5.29668 9.15652 4.93087 9.90848 4.93087H10.3352C11.6969 4.93087 12.7536 6.02829 12.7536 7.41024V12.6331Z">
                                                </path>
                                            </g>
                                        </svg>
                                    </span>
                                </a>
                            </li>

                        </ul>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- contact-us part end  -->

    <div class="map footer-top-pad">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="map-thumb">
                        <iframe src="{{ html_decode($contact_us->map_code) }}"  allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

</main>

@endsection

@push('js_section')
<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
    (function($) {
        "use strict"
        $(document).ready(function () {

            $('#contact_message_btn').on("click", function(){
                $(".contuct-us-form").submit();
            });

        });
    })(jQuery);

</script>

@endpush

