@extends('layout')
@section('title')
    <title>{{ __('translate.Dashboard') }}</title>
@endsection
@section('body-content')

<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.Dashboard') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.Dashboard') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->







    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad ">
        <div class="container">
            <div class="row">


                @include('profile.sidebar')


                <div class=" col-xxl-9 col-xl-8 col-lg-8">
                    <div class="row g-3">
                        <div class=" col-xxl-3 col-xl-6  col-lg-6 col-sm-6">
                            <div class="dashboard-item">
                                <div class="dashboard-item-icon">
                                    <span>
                                        <svg width="24" height="26" viewBox="0 0 20 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.3449 9.13383L10.5038 0.552223C9.98242 0.0474253 9.13895 0.0533979 8.62435 0.551579C8.10683 1.05513 8.10683 1.87274 8.62435 2.37565L17.4667 10.9567C17.9847 11.4594 18.8269 11.4594 19.3449 10.9567C19.8643 10.4525 19.8643 9.63785 19.3449 9.13383Z" />
                                            <path
                                                d="M7.96831 3.56348L7.90176 3.8872C7.43303 6.16275 6.29385 8.32455 4.75305 10.0767L9.56334 14.7451C11.3685 13.2501 13.5653 12.1148 15.9101 11.6593L16.2443 11.5947L7.96831 3.56348Z" />
                                            <path
                                                d="M3.8712 11.042L0.583687 14.2319C-0.193108 14.9858 -0.19634 16.2097 0.583687 16.9667L2.4619 18.7896C3.23869 19.5435 4.49981 19.5466 5.27983 18.7896L8.56703 15.5993L3.8712 11.042ZM4.34077 16.0554C4.08137 16.3071 3.66107 16.3071 3.40167 16.0554C3.14226 15.8036 3.14226 15.3957 3.40167 15.144L4.34077 14.2326C4.60018 13.9808 5.02047 13.9808 5.27988 14.2326C5.53928 14.4843 5.53928 14.8922 5.27988 15.144L4.34077 16.0554Z" />
                                            <path
                                                d="M11.3399 19.1337L12.2434 18.257C13.0234 17.5 13.0209 16.2761 12.2434 15.5228L11.5724 14.8711C11.2015 15.1129 10.8473 15.3756 10.5029 15.6559L11.3043 16.4348C11.5631 16.6847 11.5649 17.0913 11.3043 17.3456L10.386 18.2368L9.03638 16.9678L7.15808 18.7908L10.1713 21.6244C10.6855 22.1247 11.5297 22.1276 12.0488 21.6238C12.567 21.1209 12.567 20.3033 12.0488 19.8003L11.3399 19.1337Z" />
                                            <path
                                                d="M14.0228 0C13.6557 0 13.3586 0.288278 13.3586 0.644532V1.9336C13.3586 2.28985 13.6557 2.57813 14.0228 2.57813C14.3898 2.57813 14.6869 2.28985 14.6869 1.9336V0.644532C14.6869 0.288278 14.3898 0 14.0228 0Z" />
                                            <path
                                                d="M19.3357 5.15625H18.0075C17.6404 5.15625 17.3434 5.44453 17.3434 5.80078C17.3434 6.15704 17.6404 6.44531 18.0075 6.44531H19.3357C19.7028 6.44531 19.9999 6.15704 19.9999 5.80078C19.9999 5.44453 19.7028 5.15625 19.3357 5.15625Z" />
                                            <path
                                                d="M18.477 1.47788C18.2176 1.22612 17.7973 1.22612 17.5379 1.47788L16.2097 2.76694C15.9503 3.0187 15.9503 3.4266 16.2097 3.67835C16.4691 3.93011 16.8894 3.93015 17.1488 3.67835L18.477 2.38929C18.7364 2.13754 18.7364 1.72963 18.477 1.47788Z" />
                                        </svg>
                                    </span>
                                </div>

                                <div class="dashboard-item-text">
                                    <h5>{{ __('translate.Total Listing') }}</h5>

                                    <h2><span class="counter">{{ $total_listing }}</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class=" col-xxl-3 col-xl-6 col-lg-6 col-sm-6">
                            <div class="dashboard-item two">
                                <div class="dashboard-item-icon">
                                    <span>
                                        <svg width="24" height="26" viewBox="0 0 20 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.3449 9.13383L10.5038 0.552223C9.98242 0.0474253 9.13895 0.0533979 8.62435 0.551579C8.10683 1.05513 8.10683 1.87274 8.62435 2.37565L17.4667 10.9567C17.9847 11.4594 18.8269 11.4594 19.3449 10.9567C19.8643 10.4525 19.8643 9.63785 19.3449 9.13383Z" />
                                            <path
                                                d="M7.96831 3.56348L7.90176 3.8872C7.43303 6.16275 6.29385 8.32455 4.75305 10.0767L9.56334 14.7451C11.3685 13.2501 13.5653 12.1148 15.9101 11.6593L16.2443 11.5947L7.96831 3.56348Z" />
                                            <path
                                                d="M3.8712 11.042L0.583687 14.2319C-0.193108 14.9858 -0.19634 16.2097 0.583687 16.9667L2.4619 18.7896C3.23869 19.5435 4.49981 19.5466 5.27983 18.7896L8.56703 15.5993L3.8712 11.042ZM4.34077 16.0554C4.08137 16.3071 3.66107 16.3071 3.40167 16.0554C3.14226 15.8036 3.14226 15.3957 3.40167 15.144L4.34077 14.2326C4.60018 13.9808 5.02047 13.9808 5.27988 14.2326C5.53928 14.4843 5.53928 14.8922 5.27988 15.144L4.34077 16.0554Z" />
                                            <path
                                                d="M11.3399 19.1337L12.2434 18.257C13.0234 17.5 13.0209 16.2761 12.2434 15.5228L11.5724 14.8711C11.2015 15.1129 10.8473 15.3756 10.5029 15.6559L11.3043 16.4348C11.5631 16.6847 11.5649 17.0913 11.3043 17.3456L10.386 18.2368L9.03638 16.9678L7.15808 18.7908L10.1713 21.6244C10.6855 22.1247 11.5297 22.1276 12.0488 21.6238C12.567 21.1209 12.567 20.3033 12.0488 19.8003L11.3399 19.1337Z" />
                                            <path
                                                d="M14.0228 0C13.6557 0 13.3586 0.288278 13.3586 0.644532V1.9336C13.3586 2.28985 13.6557 2.57813 14.0228 2.57813C14.3898 2.57813 14.6869 2.28985 14.6869 1.9336V0.644532C14.6869 0.288278 14.3898 0 14.0228 0Z" />
                                            <path
                                                d="M19.3357 5.15625H18.0075C17.6404 5.15625 17.3434 5.44453 17.3434 5.80078C17.3434 6.15704 17.6404 6.44531 18.0075 6.44531H19.3357C19.7028 6.44531 19.9999 6.15704 19.9999 5.80078C19.9999 5.44453 19.7028 5.15625 19.3357 5.15625Z" />
                                            <path
                                                d="M18.477 1.47788C18.2176 1.22612 17.7973 1.22612 17.5379 1.47788L16.2097 2.76694C15.9503 3.0187 15.9503 3.4266 16.2097 3.67835C16.4691 3.93011 16.8894 3.93015 17.1488 3.67835L18.477 2.38929C18.7364 2.13754 18.7364 1.72963 18.477 1.47788Z" />
                                        </svg>
                                    </span>
                                </div>

                                <div class="dashboard-item-text">
                                    <h5>{{ __('translate.Featured Listing') }}</h5>

                                    <h2><span class="counter">{{ $total_featured_listing }}</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class=" col-xxl-3 col-xl-6  col-lg-6  col-sm-6">
                            <div class="dashboard-item three">
                                <div class="dashboard-item-icon">
                                    <span>
                                        <svg  width="24" height="26"viewBox="0 0 20 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M19.3449 9.13383L10.5038 0.552223C9.98242 0.0474253 9.13895 0.0533979 8.62435 0.551579C8.10683 1.05513 8.10683 1.87274 8.62435 2.37565L17.4667 10.9567C17.9847 11.4594 18.8269 11.4594 19.3449 10.9567C19.8643 10.4525 19.8643 9.63785 19.3449 9.13383Z" />
                                            <path
                                                d="M7.96831 3.56348L7.90176 3.8872C7.43303 6.16275 6.29385 8.32455 4.75305 10.0767L9.56334 14.7451C11.3685 13.2501 13.5653 12.1148 15.9101 11.6593L16.2443 11.5947L7.96831 3.56348Z" />
                                            <path
                                                d="M3.8712 11.042L0.583687 14.2319C-0.193108 14.9858 -0.19634 16.2097 0.583687 16.9667L2.4619 18.7896C3.23869 19.5435 4.49981 19.5466 5.27983 18.7896L8.56703 15.5993L3.8712 11.042ZM4.34077 16.0554C4.08137 16.3071 3.66107 16.3071 3.40167 16.0554C3.14226 15.8036 3.14226 15.3957 3.40167 15.144L4.34077 14.2326C4.60018 13.9808 5.02047 13.9808 5.27988 14.2326C5.53928 14.4843 5.53928 14.8922 5.27988 15.144L4.34077 16.0554Z" />
                                            <path
                                                d="M11.3399 19.1337L12.2434 18.257C13.0234 17.5 13.0209 16.2761 12.2434 15.5228L11.5724 14.8711C11.2015 15.1129 10.8473 15.3756 10.5029 15.6559L11.3043 16.4348C11.5631 16.6847 11.5649 17.0913 11.3043 17.3456L10.386 18.2368L9.03638 16.9678L7.15808 18.7908L10.1713 21.6244C10.6855 22.1247 11.5297 22.1276 12.0488 21.6238C12.567 21.1209 12.567 20.3033 12.0488 19.8003L11.3399 19.1337Z" />
                                            <path
                                                d="M14.0228 0C13.6557 0 13.3586 0.288278 13.3586 0.644532V1.9336C13.3586 2.28985 13.6557 2.57813 14.0228 2.57813C14.3898 2.57813 14.6869 2.28985 14.6869 1.9336V0.644532C14.6869 0.288278 14.3898 0 14.0228 0Z" />
                                            <path
                                                d="M19.3357 5.15625H18.0075C17.6404 5.15625 17.3434 5.44453 17.3434 5.80078C17.3434 6.15704 17.6404 6.44531 18.0075 6.44531H19.3357C19.7028 6.44531 19.9999 6.15704 19.9999 5.80078C19.9999 5.44453 19.7028 5.15625 19.3357 5.15625Z" />
                                            <path
                                                d="M18.477 1.47788C18.2176 1.22612 17.7973 1.22612 17.5379 1.47788L16.2097 2.76694C15.9503 3.0187 15.9503 3.4266 16.2097 3.67835C16.4691 3.93011 16.8894 3.93015 17.1488 3.67835L18.477 2.38929C18.7364 2.13754 18.7364 1.72963 18.477 1.47788Z" />
                                        </svg>
                                    </span>
                                </div>

                                <div class="dashboard-item-text">
                                    <h5>{{ __('translate.Pending') }}</h5>

                                    <h2><span class="counter">{{ $pending_listing }}</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class=" col-xxl-3 col-xl-6  col-lg-6 col-sm-6">
                            <div class="dashboard-item four">
                                <div class="dashboard-item-icon">
                                    <span>
                                    <svg  width="24" height="26"viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z">
                            </path>
                        </svg>
                                    </span>
                                </div>

                                <div class="dashboard-item-text">
                                    <h5>{{ __('translate.Wishlist') }}</h5>

                                    <h2><span class="counter">{{ $total_wishlist }}</span></h2>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if ($job_posts->count() > 0)
                        <div class="row">
                            <div class="col-lg-12">

                                <h5 class="dashbord-taitle">{{ __('translate.Your Recent Job Post') }} </h5>

                                <div class="dashbord-tabel dashboard-my-job-tabel my_job_post">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>{{ __('translate.Job Post') }}</th>
                                                <th>{{ __('translate.Amount') }}</th>
                                                <th>{{ __('translate.Created') }}</th>
                                                <th>{{ __('translate.Status') }}</th>
                                                <th>{{ __('translate.Request') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            @foreach ($job_posts as $index => $job_post)
                                                <tr>
                                                    <td>
                                                        <div class="taitel-name-item">
                                                            <div class="taitel-name-thumb-main">
                                                                <div class="taitel-name-thumb">
                                                                    <img src="{{ custom_asset($job_post->thumb_image, '30x30') }}"
                                                                        alt="thumb">
                                                                </div>
                                                            </div>
                                                            <a href="{{ route('listing', $job_post->slug) }}">{{ html_decode($job_post->title) }}</a>
                                                        </div>
                                                    </td>

                                                    <td>
                                                        {{ currency($job_post->regular_price) }}
                                                    </td>

                                                    <td>
                                                        {{ $job_post->created_at->format('Y-m-d') }}
                                                    </td>

                                                    <td>
                                                        @if ($job_post->checkJobStatus($job_post->id) == 'approved')
                                                            <button type="button" class="active-btn">{{ __('translate.Hired') }}</button>
                                                        @elseif ($job_post->checkJobStatus($job_post->id) == 'pending')
                                                            <button type="button" class="active-btn close-btn">{{ __('translate.Pending') }}</button>
                                                        @else
                                                            <button type="button" class="active-btn close-btn">{{ __('translate.Rejected') }}</button>
                                                        @endif


                                                    </td>

                                                    <td>
                                                        <a href="{{ route('user.job-post-applicants', $job_post->id) }}" class="applied-btn">
                                                            {{ __('translate.View Request') }}  {{ $job_post->total_job_application }}</a>
                                                    </td>

                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

    <!-- dashboard-part-end -->

    @include('profile.logout')

</main>


@endsection

