@extends('admin.master_layout')
@section('title')
    <title>{{ isset($product) ? __('translate.Edit Product') : __('translate.Add New Product') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ isset($product) ? __('translate.Edit Product') : __('translate.Add New Product') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Product') }} >> {{ isset($product) ? __('translate.Edit Product') : __('translate.Add New Product') }}</p>
@endsection

@section('body-content')

    <form action="{{ route('admin.product.store', isset($product) ? $product->id : null) }}" method="POST" enctype="multipart/form-data">
        @csrf

        <!-- crancy Dashboard -->
        <section class="crancy-adashboard crancy-show">
            <div class="container container__bscreen">
                <div class="row">
                    <div class="col-12">
                        <div class="crancy-body">
                            <!-- Dashboard Inner -->
                            <div class="crancy-dsinner">
                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.Basic Information') }}</h4>
                                            </div>

                                            <div class="row">

                                                <div class="col-12 mg-top-form-20">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <div class="crancy__item-form--group w-100 h-100">
                                                                <label
                                                                    class="crancy__item-label">{{ __('translate.Thumbnail Image') }}
                                                                    * </label>
                                                                <div
                                                                    class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                    <input type="file" class="btn-check"
                                                                           name="thumbnail_image" id="input-img1"
                                                                           autocomplete="off"
                                                                           onchange="previewImage(event)">
                                                                    <label class="crancy-image-video-upload__label"
                                                                           for="input-img1">
                                                                        <img id="view_img"
                                                                             src="{{ isset($product) && $product->thumbnail_image ? asset($product->thumbnail_image) : asset($setting->placeholder_image) }}">
                                                                        <h4 class="crancy-image-video-upload__title">{{ __('translate.Click here to') }}
                                                                            <span
                                                                                class="crancy-primary-color">{{ __('translate.Choose File') }}</span> {{ __('translate.and upload') }}
                                                                        </h4>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                            <div class="col-md-9">
                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Title') }}
                                                                    * </label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="name" id="name"
                                                                       value="{{ old('name', $product->name ?? '') }}">
                                                            </div>


                                                            <div class="crancy__item-form--group mg-top-form-20">
                                                                <label class="crancy__item-label">{{ __('translate.Slug') }} *</label>
                                                                <input class="crancy__item-input" type="text"
                                                                       name="slug" id="slug"
                                                                       value="{{ old('slug', $product->slug ?? '') }}">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <div class="col-md-6">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Sub Category') }} * </label>
                                                        <select class="form-select crancy__item-input" name="sub_category_id" id="sub_category_id">
                                                            <option value="">{{ __('translate.Select Sub Category') }}</option>
                                                            @foreach ($subCategories as $sub_category)
                                                                <option value="{{ $sub_category->id }}" {{ (isset($product) && $product->sub_category_id == $sub_category->id) ? 'selected' : '' }}>
                                                                    {{ $sub_category->translate->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                </div>

                                                <div class="col-md-6">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label
                                                            class="crancy__item-label">{{ __('translate.Child Category') }} </label>
                                                        <select class="form-select crancy__item-input"
                                                                name="child_category_id" id="child_category_id">
                                                            <option value="">{{ __('translate.Select') }}</option>

                                                        </select>
                                                    </div>
                                                </div>


                                                <div class="col-md-6">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Price') }} *</label>
                                                        <input class="crancy__item-input" type="number" name="price" id="price" value="{{ old('price', $product->price ?? '') }}">
                                                    </div>
                                                </div>

                                                <div class="col-md-6">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Offer Price') }} *</label>
                                                        <div class="input-group">
                                                            <input class="crancy__item-input form-control offer-price" type="number" name="offer_price" id="offer_price" value="{{ old('offer_price', $product->offer_price ?? '') }}">
                                                            <span class="input-group-text">%</span>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Small Description') }}</label>
                                                        <textarea class="crancy__item-input" type="text" name="small_description" id="small_description">{{ old('small_description', $product->small_description ?? '') }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('is Trending?') }}</label>
                                                        <div class="crancy-ptabs__notify-switch crancy-ptabs__notify-switch--two">
                                                            <input type="hidden" name="is_trending" value="0"> <!-- Default value when unchecked -->
                                                            <label class="crancy__item-switch">
                                                                <input name="is_trending" type="checkbox" value="1" {{ old('is_trending', $product->is_trending ?? 1) ? 'checked' : '' }}>
                                                                <span class="crancy__item-switch--slide crancy__item-switch--round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Description') }} *</label>
                                                        <textarea class="crancy__item-input crancy__item-textarea summernote" name="description" id="description">{{ old('description', $product->description ?? '') }}</textarea>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </div>
                            <!-- End Dashboard Inner -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End crancy Dashboard -->

        <!-- crancy Dashboard -->
        <section class="crancy-adashboard crancy-show">
            <div class="container container__bscreen">
                <div class="row">
                    <div class="col-12">
                        <div class="crancy-body">
                            <!-- Dashboard Inner -->
                            <div class="crancy-dsinner">
                                <div class="row">
                                    <div class="col-12">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.SKU Code') }}</h4>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <div class="crancy__item-form--added">
                                                            <input class="crancy__item-input" type="text" name="sku" id="sku" value="{{ old('sku', $product->sku ?? '') }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </div>
                            <!-- End Dashboard Inner -->
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!-- End crancy Dashboard -->

        <!-- crancy Dashboard -->
        <section class="crancy-adashboard crancy-show">
            <div class="container container__bscreen">
                <div class="row">
                    <div class="col-12">
                        <div class="crancy-body">
                            <!-- Dashboard Inner -->
                            <div class="crancy-dsinner">
                                <div class="row">
                                    <div class="col-12">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.SEO Information') }}</h4>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.SEO title') }} </label>
                                                        <input class="crancy__item-input" type="text" name="seo_title"
                                                               id="seo_title" value="{{ old('seo_title', $product->translate->seo_title ?? '') }}">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.SEO Description') }} </label>
                                                        <textarea class="crancy__item-input crancy__item-textarea seo_description_box"
                                                                  name="seo_description"
                                                                  id="seo_description">{{ old('seo_description', $product->translate->seo_description ?? '') }}</textarea>
                                                    </div>
                                                </div>
                                            </div>


                                            <button class="crancy-btn mg-top-25" type="submit">
                                                {{ isset($product) ? __('translate.Update Data') : __('translate.Save Data') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </form>
@endsection


@push('style_section')

    <style>
        .offer-price{
            width: auto !important;
        }
    </style>
@endpush

@push('js_section')

    <script src="{{ asset('global/tinymce/js/tinymce/tinymce.min.js') }}"></script>

    <script>
        (function ($) {
            "use strict"
            $(document).ready(function () {
                $("#name").on("keyup", function (e) {
                    let inputValue = $(this).val();
                    let slug = inputValue.toLowerCase().replace(/[^\w ]+/g, '').replace(/ +/g, '-');
                    $("#slug").val(slug);
                });

                // Load child categories for existing product
                let sub_category_id = $("#sub_category_id").val();
                let existingChildCategoryId = "{{ isset($product) ? $product->child_category_id : '' }}";

                if (sub_category_id) {
                    $.ajax({
                        type: "get",
                        url: "{{ url('child-categories-by-sub-category') }}" + "/" + sub_category_id,
                        success: function (response) {
                            $("#child_category_id").html(response);
                            // Set the selected child category if it exists
                            if (existingChildCategoryId) {
                                $("#child_category_id").val(existingChildCategoryId);
                            }
                        },
                        error: function (response) {
                            let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                            $("#child_category_id").html(empty_html);
                        }
                    });
                }

                // Handle sub category change
                $("#sub_category_id").on("change", function (e) {
                    let sub_category_id = $(this).val();

                    if (sub_category_id) {
                        $.ajax({
                            type: "get",
                            url: "{{ url('child-categories-by-sub-category') }}" + "/" + sub_category_id,
                            success: function (response) {
                                $("#child_category_id").html(response);
                            },
                            error: function (response) {
                                let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                                $("#child_category_id").html(empty_html);
                            }
                        });
                    } else {
                        let empty_html = `<option value="">{{ __('translate.Select') }}</option>`;
                        $("#child_category_id").html(empty_html);
                    }
                });

                tinymce.init({
                    selector: '.summernote',
                    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
                    tinycomments_mode: 'embedded',
                    tinycomments_author: 'Author name',
                    mergetags_list: [
                        {value: 'First.Name', title: 'First Name'},
                        {value: 'Email', title: 'Email'},
                    ]
                });
            });
        })(jQuery);

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function () {
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }
            reader.readAsDataURL(event.target.files[0]);
        };

    </script>
@endpush

