<?php

use Illuminate\Support\Facades\Route;
use Modules\Listing\Http\Controllers\ListingController;
use Modules\Listing\Http\Controllers\Frontend\ListingController as FrontendListingController;


Route::group(['middleware' => ['XSS','DEMO']], function () {

    Route::group(['as'=> 'admin.', 'prefix' => 'admin/listing', 'middleware' => ['auth:admin']],function (){

        Route::resource('listings', ListingController::class);
        Route::get('awaiting-listings', [ListingController::class, 'awaiting_listings'])->name('awaiting-listings');
        Route::get('featured-listings', [ListingController::class, 'featured_listings'])->name('featured-listings');
        Route::get('booking-listings', [ListingController::class, 'bookingListings'])->name('bookingListings');
        Route::delete('booking/delete/{id}', [ListingController::class, 'bookingDelete'])->name('bookingDelete');
        Route::post('booking/status/{id}', [ListingController::class, 'bookingStatus'])->name('bookingStatus');

        Route::get('select-listings-purpose', [ListingController::class, 'select_listings_purpose'])->name('select-listings-purpose');
        Route::get('listings-gallery/{id}', [ListingController::class, 'listing_gallery'])->name('listings-gallery');
        Route::post('upload-gallery/{id}', [ListingController::class, 'upload_listing_gallery'])->name('upload-gallery');
        Route::delete('delete-gallery/{id}', [ListingController::class, 'delete_listing_gallery'])->name('delete-gallery');

        Route::put('listings-approval/{id}', [ListingController::class, 'listings_approval'])->name('listings-approval');
        Route::put('listings-featured/{id}', [ListingController::class, 'listings_featured'])->name('listings-featured');
        Route::put('listings-featured-removed/{id}', [ListingController::class, 'listings_featured_removed'])->name('listings-featured-removed');

        Route::get('review-list', [ListingController::class, 'review_list'])->name('review-list');
        Route::get('review-detail/{id}', [ListingController::class, 'review_detail'])->name('review-detail');
        Route::delete('review-delete/{id}', [ListingController::class, 'review_delete'])->name('review-delete');
        Route::put('review-approval/{id}', [ListingController::class, 'review_approval'])->name('review-approval');

        Route::get('report-list', [ListingController::class, 'report_list'])->name('report-list');
        Route::get('report-detail/{id}', [ListingController::class, 'report_detail'])->name('report-detail');
        Route::delete('report-delete/{id}', [ListingController::class, 'report_delete'])->name('report-delete');

        Route::get('/job-posts', [ListingController::class, 'job_posts'])->name('job-posts');
        Route::get('/job-post-applicants/{id}', [ListingController::class,  'job_post_applicants'])->name('job-post-applicants');
        Route::put('/job-application-approval/{id}', [ListingController::class,  'job_application_approval'])->name('job-application-approval');
        Route::delete('/job-application-delete/{id}', [ListingController::class,  'job_application_delete'])->name('job-application-delete');

    });

    Route::group(['middleware' => ['HtmlSpecialchars', 'auth:web', 'LangSession']], function () {

        Route::group(['as'=> 'user.', 'prefix' => 'user'],function (){

            Route::get('select-listing-purpose', [FrontendListingController::class, 'select_listing_purpose'])->name('select-listing-purpose');

            Route::resource('listing', FrontendListingController::class);

            Route::get('listing-gallery/{id}', [FrontendListingController::class, 'listing_gallery'])->name('listing-gallery');
            Route::post('upload-gallery/{id}', [FrontendListingController::class, 'upload_listing_gallery'])->name('upload-gallery');
            Route::delete('delete-gallery/{id}', [FrontendListingController::class, 'delete_listing_gallery'])->name('delete-gallery');

        });
    });


});

