<?php

use Modules\Page\Http\Controllers\EcomBannerController;
use Modules\Page\Http\Controllers\TermsConditionController;
use Modules\Page\Http\Controllers\PrivacyPolicyController;
use Modules\Page\Http\Controllers\FaqController;
use Modules\Page\Http\Controllers\CustomPageController;
use Modules\Page\Http\Controllers\ContactUsController;
use Modules\Page\Http\Controllers\AboutUsController;
use Modules\Page\Http\Controllers\IntroController;
use Modules\Page\Http\Controllers\WorkingStepController;
use Modules\Page\Http\Controllers\CounterController;
use Modules\Page\Http\Controllers\ExploreController;
use Modules\Page\Http\Controllers\SaftyTipsController;
use Modules\Page\Http\Controllers\Admin\SliderController;

Route::group(['as'=> 'admin.', 'prefix' => 'admin', 'middleware' => ['XSS','DEMO','auth:admin']],function (){

    Route::controller(TermsConditionController::class)->group(function () {
        Route::get('terms-and-conditions', 'index')->name('terms-and-conditions');
        Route::put('update-terms-and-conditions', 'update')->name('update-terms-and-conditions');
    });

    Route::controller(PrivacyPolicyController::class)->group(function () {
        Route::get('privacy-policy', 'index')->name('privacy-policy');
        Route::put('update-privacy-policy', 'update')->name('update-privacy-policy');
    });

    Route::resources([
        'faq' => FaqController::class,
        'custom-page' => CustomPageController::class,
    ]);

    Route::put('faq-image', [FaqController::class, 'faq_image'])->name('faq-image');

    Route::controller(ContactUsController::class)->group(function () {
        Route::get('contact-us', 'index')->name('contact-us');
        Route::put('update-contact-us', 'update')->name('update-contact-us');
    });

    Route::controller(AboutUsController::class)->group(function () {
        Route::get('about-us', 'index')->name('about-us');
        Route::put('update-about-us', 'update')->name('update-about-us');
    });

    Route::controller(IntroController::class)->group(function () {
        Route::get('home1-intro', 'index')->name('home1-intro');
        Route::put('update-home1-intro', 'update')->name('update-home1-intro');

        Route::get('home2-intro', 'home2_intro')->name('home2-intro');
        Route::put('update-home2-intro', 'home2_intro_update')->name('update-home2-intro');

        Route::get('home3-intro', 'home3_intro')->name('home3-intro');
        Route::put('update-home3-intro', 'home3_intro_update')->name('update-home3-intro');

        Route::get('home4-intro', 'home4_intro')->name('home4-intro');
        Route::put('update-home4-intro', 'home4_intro_update')->name('update-home4-intro');
    });

    Route::controller(WorkingStepController::class)->group(function () {
        Route::get('working-step', 'index')->name('working-step');
        Route::put('update-working-step', 'update')->name('update-working-step');
    });

    Route::controller(CounterController::class)->group(function () {
        Route::get('counter', 'index')->name('counter');
        Route::put('update-counter', 'update')->name('update-counter');
    });

    Route::controller(ExploreController::class)->group(function () {
        Route::get('home1-explore', 'index')->name('home1-explore');
        Route::put('update-home1-explore', 'update')->name('update-home1-explore');

        Route::get('home2-explore', 'home2_index')->name('home2-explore');
        Route::put('update-home2-explore', 'home2_update')->name('update-home2-explore');

        Route::get('home3-explore', 'home3_index')->name('home3-explore');
        Route::put('update-home3-explore', 'home3_update')->name('update-home3-explore');

    });

    Route::controller(SaftyTipsController::class)->group(function () {
        Route::get('safety-tips', 'index')->name('safety-tips');
        Route::put('update-safety-tips', 'update')->name('update-safety-tips');


    });

    Route::prefix('slider')->controller(SliderController::class)->name('slider.')->group(function (){
        Route::get('/','index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::post('store/{id?}', 'store')->name('store');
        Route::put('status/{id?}', 'status')->name('status');
        Route::delete('delete/{id?}', 'destroy')->name('delete');
    });

    Route::controller(EcomBannerController::class)->prefix('banner')->name('banner.')->group(function (){
        Route::get('/','index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::get('edit/{id}', 'edit')->name('edit');
        Route::post('store/{id?}', 'store')->name('store');
    });

});
