<?php

namespace Modules\Category\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Listing\Entities\Listing;
use Modules\Language\Entities\Language;
use Modules\Category\Entities\SubCategory;
use Illuminate\Contracts\Support\Renderable;
use Modules\Category\Entities\ChildCategory;
use Modules\Category\Entities\ChildCategoryTranslation;
use Modules\Category\Http\Requests\ChildCategoryRequest;

class ChildCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $child_categories = ChildCategory::latest()->get();

        return view('category::child-category.index', ['child_categories' => $child_categories]);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $sub_categories = SubCategory::latest()->get();

        return view('category::child-category.create', ['sub_categories' => $sub_categories]);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(ChildCategoryRequest $request)
    {
        $child_category = new ChildCategory();

        $child_category->sub_category_id = $request->sub_category_id;
        $child_category->slug = $request->slug;
        $child_category->status = $request->status ? 'enable' : 'disable';
        $child_category->save();

        $languages = Language::all();
        foreach($languages as $language){
            $child_translation = new ChildCategoryTranslation();
            $child_translation->lang_code = $language->lang_code;
            $child_translation->child_category_id = $child_category->id;
            $child_translation->name = $request->name;
            $child_translation->save();
        }

        $notification= trans('translate.Created Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.child-category.edit', ['child_category' => $child_category->id, 'lang_code' => admin_lang()])->with($notification);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Request $request ,$id)
    {
        $sub_categories = SubCategory::latest()->get();
        $child_category = ChildCategory::findOrFail($id);
        $child_category_translate = ChildCategoryTranslation::where(['child_category_id' => $id, 'lang_code' => $request->lang_code])->first();

        return view('category::sub-category.edit', ['sub_categories' => $sub_categories, 'child_category' => $child_category, 'child_category_translate' => $child_category_translate]);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $child_category = ChildCategory::findOrFail($id);

        if($request->lang_code == admin_lang()){


            $child_category->sub_category_id = $request->sub_category_id;
            $child_category->slug = $request->slug;
            $child_category->status = $request->status ? 'enable' : 'disable';
            $child_category->save();

            $child_translation = ChildCategoryTranslation::findOrFail($request->translate_id);
            $child_translation->name = $request->name;
            $child_translation->save();

        }else{

            $child_translation = ChildCategoryTranslation::findOrFail($request->translate_id);
            $child_translation->name = $request->name;
            $child_translation->save();
        }

        $notification= trans('translate.Update Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $listing_qty = Listing::where('child_category_id', $id)->count();

        if($listing_qty > 0){
            $notification = trans('translate.Multiple listing created under it, so you can not delete it');
            $notification = array('messege'=>$notification,'alert-type'=>'error');
            return redirect()->back()->with($notification);
        }

        $child_category = ChildCategory::findOrFail($id);

        $child_category->delete();

        ChildCategoryTranslation::where('child_category_id', $id)->delete();

        $notification= trans('translate.Delete Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.child-category.index')->with($notification);
    }

    public function assign_language($lang_code){
        $cat_translates = ChildCategoryTranslation::where('lang_code', admin_lang())->get();
        foreach($cat_translates as $cat_translate){
            $listing_cat_translate = new ChildCategoryTranslation();
            $listing_cat_translate->lang_code = $lang_code;
            $listing_cat_translate->child_category_id = $cat_translate->child_category_id;
            $listing_cat_translate->name = $cat_translate->name;
            $listing_cat_translate->save();
        }
    }
}
