<?php

use App\Constants\Status;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->integer('category_id')->default(Status::ECOMMERCE);
            $table->integer('sub_category_id');
            $table->integer('child_category_id')->nullable();
            $table->string('name');
            $table->string('slug');
            $table->decimal('price', 8, 2);
            $table->decimal('offer_price', 8, 2)->nullable();
            $table->mediumText('small_description');
            $table->string('thumbnail_image');
            $table->string('sku');
            $table->text('description');
            $table->tinyInteger('is_trending')->default(Status::DISABLE);
            $table->tinyInteger('status')->default(Status::ENABLE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
