<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('ecom_banner_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('banner_id')->constrained('ecom_banners')->onDelete('cascade');
            $table->string('lang_code')->index();
            $table->string('sub_title')->nullable();
            $table->string('title')->nullable();
            $table->mediumText('description')->nullable();
            $table->string('button_text')->nullable();
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('ecom_banner_translations');
    }
};
