<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\HomePageTranslation;
use Modules\Page\Http\Requests\CounterRequest;
use Image, File, Str;


class CounterController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        $counter = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $counter->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.counter', compact('counter','translate'));
    }

    public function update(CounterRequest $request)
    {

        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();

        $translate->counter_title1 = $request->counter_title1;
        $translate->counter_title2 = $request->counter_title2;
        $translate->counter_title3 = $request->counter_title3;
        $translate->counter_title4 = $request->counter_title4;
        $translate->save();

        $counter = HomePage::first();

        if($request->lang_code == admin_lang()){
            $counter->counter_qty1 = $request->counter_qty1;
            $counter->counter_qty2 = $request->counter_qty2;
            $counter->counter_qty3 = $request->counter_qty3;
            $counter->counter_qty4 = $request->counter_qty4;
            $counter->save();
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

}
