<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\HomePage;
use Modules\Page\Entities\HomePageTranslation;
use Modules\Page\Http\Requests\ExploreRequest;
use Modules\Page\Http\Requests\Explore2Request;
use Modules\Page\Http\Requests\Explore3Request;
use Image, File, Str;

class ExploreController extends Controller
{

    public function index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home1_explore', compact('homepage', 'translate'));
    }


    public function update(ExploreRequest $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home1_explore_title = $request->home1_explore_title;
        $translate->home1_explore_des = $request->home1_explore_des;
        $translate->save();

        $homepage = HomePage::first();

        if($request->home1_explore_image){
            $old_image = $homepage->home1_explore_image;
            $image_name = 'home1-explore-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home1_explore_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $homepage->home1_explore_image = $image_name;
            $homepage->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function home2_index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home2_explore', compact('homepage', 'translate'));
    }

    public function home2_update(Explore2Request $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home2_explore_title = $request->home2_explore_title;
        $translate->home2_explore_des = $request->home2_explore_des;
        $translate->save();

        $homepage = HomePage::first();

        if($request->home2_explore_image){
            $old_image = $homepage->home2_explore_image;
            $image_name = 'home1-explore-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home2_explore_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $homepage->home2_explore_image = $image_name;
            $homepage->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }


    public function home3_index(Request $request)
    {
        $homepage = HomePage::first();
        $translate = HomePageTranslation::where(['home_page_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.home3_explore', compact('homepage', 'translate'));
    }

    public function home3_update(Explore3Request $request)
    {
        $translate = HomePageTranslation::where(['id' => $request->translate_id])->first();
        $translate->home3_explore_title = $request->home3_explore_title;
        $translate->save();

        $homepage = HomePage::first();

        if($request->home3_explore_image){
            $old_image = $homepage->home3_explore_image;
            $image_name = 'home1-explore-image'.date('-Y-m-d-h-i-s-').rand(999,9999).'.webp';
            $image_name ='uploads/website-images/'.$image_name;
            Image::make($request->home3_explore_image)
                ->encode('webp', 80)
                ->save(public_path().'/'.$image_name);
            $homepage->home3_explore_image = $image_name;
            $homepage->save();

            if($old_image){
                if(File::exists(public_path().'/'.$old_image))unlink(public_path().'/'.$old_image);
            }
        }

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }
}
