<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\GeneralSetting\Entities\Setting;
use Modules\Page\Http\Requests\SaftyTipsRequest;

class SaftyTipsController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('page::section.saftytips');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function update(SaftyTipsRequest $request)
    {
        $setting = Setting::first();
        $setting->safetytips = $request->safetytips;
        $setting->save();

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

}
