<?php

namespace Modules\Page\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AboutRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'header'=>'required',
            'title'=>'required',
            'description'=>'required',
            'ceo_name'=>'required',
            'ceo_designation'=>'required'
        ];

        if($this->request->get('lang_code') == admin_lang()){
            $rules['experience_year'] = 'required';
        }

        return $rules;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return [
            'experience_year.required' => trans('translate.Year is required'),
            'header.required' => trans('translate.Short title is required'),
            'title.required' => trans('translate.Title is required'),
            'description.required' => trans('translate.Description is required'),
            'ceo_name.required' => trans('translate.Name is required'),
            'ceo_designation.required' => trans('translate.Designation is required'),
        ];
    }
}
