<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('ticket_messages', function (Blueprint $table) {
            $table->id();
            $table->integer('support_ticket_id');
            $table->integer('user_id');
            $table->integer('admin_id');
            $table->text('message');
            $table->string('message_from')->comment('user, admin');
            $table->string('seen_by_admin')->default('no');
            $table->string('seen_by_user')->default('no');
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('ticket_messages');
    }
};
