@extends('layout')
@section('title')
    <title>{{ __('translate.Manage Kyc') }}</title>
@endsection
@section('body-content')
<main>
    @php
        use App\Constants\Status;
    @endphp
    <!-- banner-part-start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{  custom_asset($breadcrumb, '1904x408') }});">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">

                <div class="inner-bg-txt">
                    <h1>{{ __('translate.Manage Kyc') }}</h1>

                    <ul>
                        <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                        <li><span>
                                <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                </svg>

                            </span></li>
                        <li><a href="javascript:;" class="active">{{ __('translate.Manage Kyc') }}</a></li>
                    </ul>
                </div>

            </div>
        </div>
    </div>
</div>
    <!-- banner-part-end -->




    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad">
        <div class="container">
            <div class="row">
                @include('profile.sidebar')

                @if ($kyc)
                <div class=" col-xxl-9 col-xl-8 col-lg-8">
                    <!-- crancy Table -->
                        <div class="dashboard-ad-listing-box">
                            <div class="dashboard-ad-listing-box-icon-main">
                                <div class="dashboard-ad-listing-box-icon">
                                    <div class="dashboard-ad-listing-box-thumb">
                                        <a href="{{  custom_asset($kyc->file) }}">
                                            <img width="120" src="{{  custom_asset($kyc->file, '120x64') }}" alt="">
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <h2>{{ $kyc->kyc_type->name}}</h2>
                            <h5>{{ $kyc->message}}</h5>
                                @if ($kyc->status == Status::PENDING)
                                    <a class="main-btn btn btn-dark">
                                        <div class="homec-dashboard-property__label">{{__('translate.Pending')}}</div>
                                    </a>
                                @elseif ($kyc->status == Status::APPROVED)
                                    <a class="main-btn btn btn-success">
                                        <div class="homec-dashboard-property__label">{{__('translate.Approved')}}</div>
                                    </a>
                                @elseif ($kyc->status == Status::REJECTED)
                                    <a class="main-btn btn btn-danger">
                                        <div class="homec-dashboard-property__label">{{__('translate.Reject')}}</div>
                                    </a>
                                @endif
                        </div>
                    <!-- End KYC Table -->
                </div>
                @else
                    <div class=" col-xxl-9 col-xl-8 col-lg-8">
                            <!-- Kyc Veryfication  -->
                        <form action="{{ route('user.kyc-submit') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row login-bg">

                                    <div class="col-lg-6">
                                        <div class="login-head">
                                            <h3>{{ __('translate.Manage Kyc') }}</h3>
                                        </div>

                                            <div class="description-item">
                                                <div class="description-item-inner">
                                                    <label class="form-label">{{ __('translate.Sub Category') }}
                                                        <span>*</span> </label>
                                                    <select class="form-select" name="kyc_id">
                                                        <option value="">{{__('translate.Select Type')}}</option>
                                                        @foreach ($kycType as $type)
                                                            <option  {{ $type->id == old('kyc_id') ? 'selected' : '' }} value="{{ $type->id }}">{{ $type->name }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="description-item">
                                                <div class="description-item-inner">
                                                    <label class="form-label">{{ __('translate.Message') }}
                                                        </label>
                                                    <textarea class="form-control" rows="4"
                                                        placeholder="{{ __('translate.Message') }}" name="message" id="message">{{ old('message') }}</textarea>
                                                </div>
                                            </div>


                                            <div class="login-form-item-btn">
                                                <button type="submit" class="main-btn two">{{ __('translate.Submit') }}</button>
                                                <a href="" class="main-btn">{{ __('translate.Cancel') }}</a>
                                            </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="login-img">
                                            <!-- Upload New Image  -->
                                            <div class="col-lg-12">
                                                <div class="car-images">
                                                    <div class="car-images-inner">

                                                        <div class="uplode-thumb-main">
                                                            <div class="uplode-thumb">
                                                                <img src="{{  custom_asset($setting->placeholder_image, '120x64') }}" alt="thumb" id="file">
                                                            </div>
                                                            <div class="uplode-thumb-main-item">
                                                                <p>{{ __('translate.Select') }} <span>{{ __('translate.New File') }}</span> {{ __('translate.to Upload') }}</p>
                                                                <input type="file" id="my-file" onchange="previewImage(event)" name="file">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </form>
                    </div>
                @endif
            </div>
        </div>
        </div>
    </section>

    <!-- dashboard-part-end -->

    @include('profile.logout')
</main>

@endsection

@push('js_section')
    <script>
        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('file');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

    </script>

@endpush
