@extends('layout')
@section('title')
    <title>{{ __('translate.My Listing') }}</title>
@endsection
@section('body-content')

<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
    style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.My Listing') }}</h1>

                        <ul>
                            <li><a href={{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.My Listing') }}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- inner-bg  part end  -->

    <!-- dashboard-part-start -->
    <section class="dashboard footer-top-pad ">
        <div class="container">
            <div class="row">
                @include('profile.sidebar')
                <div class=" col-xxl-9 col-xl-8 col-lg-8">
                    @if($listings->count() > 0)
                        <div class="row align-items-end">
                            <div class="col-lg-8">
                                <ul class="shaf-filter course-filter  ">
                                    <li data-group="Classified" class="active" id="Classified_item_filter">{{ __('translate.Classified') }}</li>
                                    <li data-group="Real-Estate" class="">{{ __('translate.Real Estate') }}</li>
                                    <li data-group="JobPost" class="">{{ __('translate.Job Post') }}</li>
                                </ul>
                            </div>
                        </div>

                        <!-- Filter Content -->
                        <div class="row mt-20px g-3 shafull-container ">
                            @foreach ($listings as $index => $listing)
                            @if ($listing->category_id == 1)
                                <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item" data-groups='["Classified"]'>
                                @elseif ($listing->category_id == 2)
                                <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item" data-groups='["Real-Estate"]'>
                                @elseif ($listing->category_id == 3)
                                <div class="  col-xxl-4 col-lg-6 col-sm-6 shaf-item job-listing common-class" data-groups='["JobPost"]'>
                                @elseif ($listing->category_id == 4)
                                        <div class="  col-xxl-4 col-lg-6 col-sm-6" data-groups='["Ecommerce"]'>
                                @endif

                                    @if ($listing->category_id == 3)
                                        <div class="job-listing-item">
                                            <div class="job-listing-item-inner">
                                                <div class="job-listing-img">
                                                    <img src="{{ custom_asset($listing->thumb_image, '315x230') }}" alt="img">
                                                </div>

                                                <div class="job-listing-img-btn">
                                                    @guest('web')
                                                        <a href="javascript:;" class="before_auth_wishlist">
                                                            <span>
                                                                <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    @else
                                                        <a href="{{ route('user.add-to-wishlist', ['id' => $listing->id, 'type' => 'listing']) }}">
                                                            <span>
                                                                <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    @endguest

                                                    @if ($listing->is_urgent == 'enable')
                                                        <span class="txt">{{ __('translate.Urgent') }}</span>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="job-listing-content">
                                                <p>{{ currency($listing->regular_price) }}/{{ __('translate.m') }}</p>

                                                <a href="{{ route('listing', $listing->slug) }}">
                                                    <h3 class="job-listing-content-link">{{ html_decode($listing->title) }}</h3>
                                                </a>
                                            </div>

                                            <div class="job-listing-content-btn">
                                                <a href="javascript:;">
                                                    <span>
                                                        <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M2.97888 0.513554C2.97888 0.298962 2.80492 0.125 2.59032 0.125C2.37573 0.125 2.20177 0.298962 2.20177 0.513554V1.7167C1.35167 2.14527 0.675371 2.86822 0.306805 3.75163H9.0185C8.64993 2.86823 7.97365 2.14529 7.12357 1.71672V0.513554C7.12357 0.298962 6.94961 0.125 6.73501 0.125C6.52042 0.125 6.34646 0.298962 6.34646 0.513554V1.4222C6.02048 1.33638 5.67823 1.29067 5.3253 1.29067H4C3.64709 1.29067 3.30485 1.33638 2.97888 1.42219V0.513554ZM0 5.29067C0 5.03013 0.0249108 4.7754 0.0724807 4.52874H9.25282C9.30039 4.7754 9.3253 5.03013 9.3253 5.29068V6.87501C9.3253 9.08415 7.53444 10.875 5.3253 10.875H4C1.79086 10.875 0 9.08415 0 6.87501V5.29067ZM4.66263 7.76653C4.94876 7.76653 5.18071 7.53458 5.18071 7.24846C5.18071 6.96234 4.94876 6.73039 4.66263 6.73039C4.37651 6.73039 4.14456 6.96234 4.14456 7.24846C4.14456 7.53458 4.37651 7.76653 4.66263 7.76653ZM7.25274 7.24846C7.25274 7.53458 7.02079 7.76653 6.73467 7.76653C6.44854 7.76653 6.21659 7.53458 6.21659 7.24846C6.21659 6.96234 6.44854 6.73039 6.73467 6.73039C7.02079 6.73039 7.25274 6.96234 7.25274 7.24846ZM2.59029 7.76653C2.87641 7.76653 3.10836 7.53458 3.10836 7.24846C3.10836 6.96234 2.87641 6.73039 2.59029 6.73039C2.30417 6.73039 2.07222 6.96234 2.07222 7.24846C2.07222 7.53458 2.30417 7.76653 2.59029 7.76653Z" />
                                                        </svg>
                                                    </span>

                                                    {{ $listing->created_at->diffForHumans() }}
                                                </a>


                                                <a href="javascript:;">
                                                    <span>
                                                        <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                                d="M4.81644 11C6.56164 11 9.47029 7.58895 9.47029 4.88889C9.47029 2.18883 7.38669 0 4.81644 0C2.2462 0 0.162598 2.18883 0.162598 4.88889C0.162598 7.58895 3.07125 11 4.81644 11ZM4.81631 6.59992C5.67306 6.59992 6.36759 5.86119 6.36759 4.94992C6.36759 4.03865 5.67306 3.29992 4.81631 3.29992C3.95956 3.29992 3.26502 4.03865 3.26502 4.94992C3.26502 5.86119 3.95956 6.59992 4.81631 6.59992Z" />
                                                        </svg>
                                                    </span>

                                                    {{ html_decode($listing->address) }}
                                                </a>
                                            </div>

                                            <div class="job-listing-btn two">
                                                <a class="main-btn " href="javascript:;" onclick="deleteJobList({{ $listing->id }})">
                                                    <div class="btn_m">
                                                        <div class="btn_c">
                                                            <div class="btn_t1">{{ __('translate.Delete') }}</div>
                                                            <div class="btn_t2">{{ __('translate.Delete') }}</div>
                                                        </div>
                                                    </div>
                                                </a>
                                                <a class="main-btn two " href="{{ route('listing', $listing->slug) }}">
                                                    <div class="btn_m">
                                                        <div class="btn_c">
                                                            <div class="btn_t1">{{ __('translate.Detail Now') }}</div>
                                                            <div class="btn_t2">{{ __('translate.Detail Now') }}</div>
                                                        </div>
                                                    </div>
                                                </a>

                                                <form action="{{ route('user.listing.destroy', $listing->id) }}" id="remove_job_listing_{{ $listing->id }}" class="d-none" method="POST">
                                                    @csrf
                                                    @method('DELETE')

                                                </form>


                                            </div>
                                        </div>
                                    @else
                                        <div class="features-single-box ">
                                            <div class="features-thumb">
                                                <img src="{{ custom_asset($listing->thumb_image, '315x230') }}" alt="img">
                                            </div>

                                            <div class="features-single-box-over">
                                                <div class="text">
                                                    @if ($listing->approved_by_admin == 'pending')
                                                    <p>{{ __('translate.Awaiting') }}</p>
                                                    @endif

                                                    @if ($listing->is_featured == 'enable')
                                                    <h6>{{ __('translate.Featured') }}</h6>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="features-single-box-inner">
                                                <div class="features-single-box-inner-txt">
                                                    <p>

                                                        <span>
                                                            <svg width="11" height="12" viewBox="0 0 11 12" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M10.9992 3.43661C10.9992 4.03851 11.001 4.63998 10.9984 5.24188C10.9971 5.59777 10.8734 5.90712 10.6216 6.16046C10.253 6.53143 9.88231 6.89981 9.51201 7.26948C8.1817 8.59823 6.8514 9.92699 5.52152 11.2562C5.40297 11.3747 5.27925 11.485 5.11717 11.5405C4.78523 11.6543 4.47658 11.6069 4.21276 11.3772C3.99593 11.1881 3.79548 10.9796 3.59158 10.7762C2.52854 9.71458 1.46636 8.65166 0.405044 7.58874C0.330468 7.51421 0.257184 7.43708 0.192523 7.35393C-0.0816435 6.99977 -0.0622449 6.50946 0.245976 6.18287C0.471862 5.94331 0.708524 5.71367 0.941737 5.48058C2.27248 4.14967 3.60365 2.81919 4.93439 1.48872C5.11415 1.30905 5.29089 1.12594 5.47453 0.949719C5.70904 0.724383 5.99527 0.604606 6.31815 0.602882C7.545 0.597712 8.77142 0.600728 9.99827 0.600728C10.275 0.600728 10.5255 0.673111 10.7251 0.876474C10.8854 1.03977 10.982 1.23494 10.9885 1.46502C10.9971 1.79979 10.9975 2.13457 10.9992 2.46934C11.001 2.79162 10.9992 3.1139 10.9992 3.43618V3.43661ZM9.16327 3.35733C9.1706 2.86228 8.77271 2.45254 8.28603 2.4353C7.76571 2.41678 7.3355 2.82695 7.33075 3.34656C7.32644 3.83773 7.72562 4.24963 8.21059 4.26902C8.72616 4.2897 9.17318 3.86703 9.16327 3.35733Z" />
                                                            </svg>
                                                        </span>
                                                        {{ $listing?->sub_category?->name }}
                                                    </p>

                                                    <span>
                                                        {{ currency($listing->regular_price) }}
                                                    </span>
                                                </div>


                                                <a href="{{ route('listing', $listing->slug) }}">
                                                    <h3>{{ html_decode($listing->title) }}</h3>
                                                </a>


                                                <div class="features-single-box-contact">
                                                    <div class="location">
                                                        <p><a href="javascript:;">
                                                                <span>
                                                                    <svg width="11" height="13" viewBox="0 0 11 13" fill="none"
                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                                            d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z" />
                                                                    </svg>
                                                                </span>
                                                                {{ html_decode($listing->address) }}
                                                            </a>
                                                        </p>
                                                    </div>


                                                    <div class="ad-listing-btn">
                                                        <a class="main-btn " href="{{ route('user.listing-gallery', $listing->id) }}">
                                                            <div class="btn_m">
                                                                <div class="btn_c">
                                                                    <div class="btn_t1">+ {{ __('translate.Gallery') }}</div>
                                                                    <div class="btn_t2">+ {{ __('translate.Gallery') }}</div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                        <div class="ad-listing-btn-left">
                                                            <a class="main-btn edit " href="{{ route('user.listing.edit', ['listing' => $listing->id, 'lang_code' => admin_lang()] ) }}">
                                                                <div class="btn_m">
                                                                    <div class="btn_c">
                                                                        <div class="btn_t1">{{ __('translate.Edit') }}</div>
                                                                        <div class="btn_t2">{{ __('translate.Edit') }}</div>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                            <a class="main-btn delete " href="javascript:;" onclick="deleteGallery({{ $listing->id }})">
                                                                <div class="btn_m">
                                                                    <div class="btn_c">
                                                                        <div class="btn_t1">{{ __('translate.Delete') }}</div>
                                                                        <div class="btn_t2">{{ __('translate.Delete') }}</div>
                                                                    </div>
                                                                </div>
                                                            </a>

                                                            <form action="{{ route('user.listing.destroy', $listing->id) }}" id="remove_listing_{{ $listing->id }}" class="d-none" method="POST">
                                                                @csrf
                                                                @method('DELETE')

                                                            </form>

                                                        </div>
                                                    </div>

                                                </div>


                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                    <div class="row g-3">
                        <div class="col-12">
                            <section class="maintenance common-class">
                                <div class="container">
                                    <div class="row justify-content-center ">
                                        <div class="col-lg-7">
                                            <div class="maintenance-item">
                                                <div class="maintenance-thumb">
                                                    <img src="{{ custom_asset($setting->not_found) }}" alt="thumg">
                                                </div>

                                                <div class="maintenance-item-txt">
                                                    <h2>{{ __('translate.Do not have a Listing') }}</h2>
                                                    <a class="main-btn " href="{{ route('user.select-listing-purpose') }}">
                                                        <div class="btn_m">
                                                            <div class="btn_c">
                                                                <div class="btn_t1">{{ __('translate.Create New Listing') }}</div>
                                                                <div class="btn_t2">{{ __('translate.Create New Listing') }}</div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </section>

    <!-- dashboard-part-end -->

    @include('profile.logout')
</main>

@endsection

@push('js_section')
<script src="{{ asset('global/sweetalert/sweetalert2@11.js') }}"></script>


<script>
    "use strict";
        function deleteGallery(id){
            Swal.fire({
                title: "{{ __('translate.Are you realy want to delete this item ?') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{__('Yes, Delete It')}}",
                cancelButtonText: "{{__('Cancel')}}",
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#remove_listing_"+id).submit();
                }

            })
        }

        function deleteJobList(id){
            Swal.fire({
                title: "{{ __('translate.Are you realy want to delete this item ?') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{__('Yes, Delete It')}}",
                cancelButtonText: "{{__('Cancel')}}",
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#remove_job_listing_"+id).submit();
                }

            })
        }


    </script>


@endpush
