<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Page\Entities\AboutUs;
use Modules\Page\Entities\AboutUsTranslation;
use Modules\Page\Http\Requests\AboutRequest;
use Image, File, Str;

class AboutUsController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function index(Request $request)
    {
        $about_us = AboutUs::first();
        $translate = AboutUsTranslation::where('lang_code', $request->lang_code)->first();

        return view('page::about_us', compact('about_us','translate'));
    }


    public function update(AboutRequest $request)
    {
        $about_us = AboutUs::first();
        if($request->lang_code == admin_lang()){
            $about_us->experience_year = $request->experience_year;
            $about_us->save();
        }

        if ($request->hasFile('about_image')) {
            $image_path = uploadFile($request->file('about_image'), 'uploads/website-images', $about_us->about_image);
            $about_us->about_image  = $image_path;
            $about_us->save();
        }

        if ($request->hasFile('ceo_image')) {
            $image_path = uploadFile($request->file('ceo_image'), 'uploads/website-images', $about_us->ceo_image);
            $about_us->ceo_image = $image_path;
            $about_us->save();
        }

        if ($request->hasFile('signature_image')) {
            $image_path = uploadFile($request->file('signature_image'), 'uploads/website-images', $about_us->signature_image);
            $about_us->signature_image = $image_path;
            $about_us->save();
        }


        $translate = AboutUsTranslation::where('lang_code', $request->lang_code)->first();
        $translate->header = $request->header;
        $translate->title = $request->title;
        $translate->description = $request->description;
        $translate->ceo_name = $request->ceo_name;
        $translate->ceo_designation = $request->ceo_designation;
        $translate->save();

        $notification= trans('translate.Updated Successfully');
        $notification=array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);

    }

    public function assign_language($lang_code){
        $about_translates = AboutUsTranslation::where('lang_code', admin_lang())->get();
        foreach($about_translates as $about_translate){
            $translate = new AboutUsTranslation();
            $translate->about_us_id = $about_translate->about_us_id;
            $translate->lang_code = $lang_code;
            $translate->header = $about_translate->header;
            $translate->title = $about_translate->title;
            $translate->description = $about_translate->description;
            $translate->ceo_name = $about_translate->ceo_name;
            $translate->ceo_designation = $about_translate->ceo_designation;
            $translate->save();
        }
    }

}
