<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DISK', 'local'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been set up for each driver as an example of the required values.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
            'throw' => false,
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL').'/storage',
            'visibility' => 'public',
            'throw' => false,
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'endpoint' => env('AWS_ENDPOINT'),
            'use_path_style_endpoint' => true,
            'use_path_style_endpoint' => env('AWS_USE_PATH_STYLE_ENDPOINT', true),
            'visibility' => 'public',
            'throw' => true,
            'options' => [
                'ChecksumAlgorithm' => null, // Disable checksum headers
            ], 'http' => [
                'request_options' => [
                    'headers' => [
                        // Ensure unsupported headers are not included
                        'x-amz-checksum-crc32' => null,
                        'x-amz-checksum-crc32c' => null,
                        'x-amz-checksum-crc64nvme' => null,
                        'x-amz-checksum-sha1' => null,
                        'x-amz-checksum-sha256' => null,
                        'x-amz-checksum-algorithm' => null,
                        'x-amz-checksum-mode' => null,
                    ]
                ]
            ]
        ],


        // 'backblaze' => [
        //     'driver' => 'backblaze',
        //     'account_id' => env('BACKBLAZE_ACCOUNT_ID'),
        //     'application_key' => env('BACKBLAZE_APPLICATION_KEY'),
        //     'bucket_name' => env('BACKBLAZE_BUCKET_NAME'),
        //     'bucket_region' => env('BACKBLAZE_BUCKET_REGION'),
        // ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
