@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')


<main>


    <!-- inner-bg  part start  -->

    <div class="inner-bg common-class"
        style="    background-image:  url({{ custom_asset($breadcrumb, '1904x408') }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">

                    <div class="inner-bg-txt">
                        <h1>{{ __('translate.About Us') }}</h1>

                        <ul>
                            <li><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li><span>
                                    <svg width="6" height="12" viewBox="0 0 6 12" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M0.633816 2.7705e-08C0.446997 0.0532405 0.28353 0.143084 0.158011 0.319443C-0.0492418 0.618921 -0.0550799 1.0515 0.155092 1.35098C0.195958 1.40755 0.239744 1.46411 0.286449 1.51735C1.56499 2.97481 2.84645 4.4356 4.125 5.89306C4.15419 5.92633 4.18922 5.95295 4.24176 6.03281C4.20673 6.0561 4.16295 6.06941 4.13375 6.10269C2.84062 7.57346 1.5504 9.04755 0.257258 10.5183C0.0295721 10.7779 -0.0579994 11.0773 0.0412483 11.4367C0.187201 11.9591 0.776848 12.1721 1.16216 11.8427C1.20595 11.8061 1.24682 11.7628 1.28768 11.7196C2.7764 10.0225 4.26511 8.32881 5.75091 6.63177C6.02238 6.32231 6.07492 5.92966 5.89394 5.57361C5.85015 5.4871 5.78594 5.41056 5.72464 5.34069C4.27971 3.69356 2.83478 2.04976 1.39277 0.399304C1.23222 0.216289 1.06875 0.0532405 0.838149 3.66367e-08C0.771011 3.3702e-08 0.703873 3.07673e-08 0.633816 2.7705e-08Z" />
                                    </svg>

                                </span></li>
                            <li><a href="javascript:;" class="active">{{ __('translate.About Us') }}</a></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- inner-bg  part end  -->



    <!-- about-us-two part start  -->
    <section class="about-us-two common-class">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="about-us-two-thumb">
                        <img src="{{ custom_asset($about_us->about_image, '573x495') }}" alt="thumb">

                        <div class="about-us-two-thumb-over">
                            <h2>{{ $about_us->experience_year }}</h2>
                            <p>{{ __('translate.Years of Experience') }}</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 about-us-two-pl  ">
                    <span class="about-us-sub-taitel">{{ $about_us->header }}</span>
                    <h2 class="taitel">{{ $about_us->title }}</h2>

                    {!! clean($about_us->description) !!}

                    <div class="about-us-two-item">

                        <div class="about-us-two-inner">
                            <div class="about-us-two-item-img">
                                <img src="{{ custom_asset($about_us->ceo_image, '76x76') }}" alt="img">
                            </div>

                            <div class="about-us-two-item-img-txt">
                                <h4>{{ $about_us->ceo_name }}</h4>

                                <p>{{ $about_us->ceo_designation }}</p>
                            </div>
                        </div>

                        <div class="about-us-two-signuture">
                            <img src="{{ custom_asset($about_us->signature_image, '90x70') }}" alt="img">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- about-us-two part end  -->


    <!-- counter part start  -->


    <section class="counter-section common-class">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="counter-item">
                        <div class="counter-item-inner">
                            <h2 data-scroll="scroll" data-value="{{ $homepage->counter_qty1 }}" data-type="+" data-speed="1000">{{ $homepage->counter_qty1 }}</h2>
                            <p>{{ $homepage->counter_title1 }}</p>
                        </div>
                        <div class="counter-item-inner">
                            <h2 data-scroll="scroll" data-value="{{ $homepage->counter_qty2 }}" data-type="+" data-speed="1000"> {{ $homepage->counter_qty2 }}</h2>
                            <p>{{ $homepage->counter_title2 }}</p>
                        </div>
                        <div class="counter-item-inner">
                            <h2 data-scroll="scroll" data-value="{{ $homepage->counter_qty3 }}" data-type="+" data-speed="1000">{{ $homepage->counter_qty3 }}</h2>
                            <p>{{ $homepage->counter_title3 }}</p>
                        </div>
                        <div class="counter-item-inner">
                            <h2 data-scroll="scroll" data-value="{{ $homepage->counter_qty4 }}" data-type="+" data-speed="1000">{{ $homepage->counter_qty4 }} </h2>
                            <p>{{ $homepage->counter_title4 }}</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>

    <!-- counter part end  -->



    <!-- work part start  -->


    <section class="work common-class">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 work-pr ">
                    <span class="work-sub-taitel">{{ $homepage->working_short_title }}</span>
                    <h2 class="taitel">{{ $homepage->working_title }}</h2>

                    <div class="row g-3 mt-20px">
                        <div class="col-lg-6 col-sm-6 " data-aos="fade-right" data-aos-delay="50">
                            <div class="work-item">
                                <span class="icon">
                                   <img src="{{ custom_asset($homepage->working_step_icon1, '51x20') }}" alt="">
                                </span>

                                <h3 class="work-item-txt">{{ $homepage->working_step_title1 }}</h3>

                                <p class="work-item-dec">{{ $homepage->working_step_des1 }}</p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-sm-6" data-aos="fade-right" data-aos-delay="100">
                            <div class="work-item">
                                <span class="icon">
                                    <img src="{{ custom_asset($homepage->working_step_icon2, '51x20') }}" alt="">
                                 </span>

                                 <h3 class="work-item-txt">{{ $homepage->working_step_title2 }}</h3>

                                 <p class="work-item-dec">{{ $homepage->working_step_des2 }}</p>
                            </div>
                        </div>

                        <div class="col-lg-6 col-sm-6" data-aos="fade-right" data-aos-delay="150">
                            <div class="work-item">
                                <span class="icon">
                                    <img src="{{ custom_asset($homepage->working_step_icon3, '51x20') }}" alt="">
                                 </span>

                                 <h3 class="work-item-txt">{{ $homepage->working_step_title3 }}</h3>

                                 <p class="work-item-dec">{{ $homepage->working_step_des3 }}</p>
                            </div>
                        </div>

                        <div class="col-lg-6 col-sm-6" data-aos="fade-right" data-aos-delay="200">
                            <div class="work-item">
                                <span class="icon">
                                    <img src="{{ custom_asset($homepage->working_step_icon4, '51x20') }}" alt="">
                                 </span>

                                 <h3 class="work-item-txt">{{ $homepage->working_step_title4 }}</h3>

                                 <p class="work-item-dec">{{ $homepage->working_step_des4 }}</p>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-lg-6" data-aos="fade-up">
                    <div class="work-vedio ">
                        <div class="work-vedio-thumb">
                            <img src="{{ custom_asset($homepage->video_image, '629x637') }}" alt="img">
                        </div>

                        <a class="my-video-links" data-autoplay="true" data-vbtype="video"
                            href="https://www.youtube.com/watch?v={{ $homepage->video_id }}">

                            <span class="icon">
                                <svg width="26" height="30" viewBox="0 0 26 30" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M24.0139 11.111L5.41584 0.482154C4.88422 0.171026 4.27879 0.00467176 3.66111 0C2.69012 0 1.75891 0.381551 1.07231 1.06072C0.385723 1.73988 0 2.66103 0 3.62151V26.4327C0.000123489 27.0701 0.172854 27.6958 0.500231 28.2448C0.827609 28.7938 1.29768 29.246 1.86157 29.5545C2.42546 29.8629 3.06258 30.0163 3.70669 29.9986C4.35079 29.981 4.97837 29.793 5.52416 29.4542L24.1438 17.8183C24.7228 17.4599 25.198 16.9592 25.5232 16.3651C25.8483 15.771 26.0124 15.1037 25.9993 14.4282C25.9862 13.7527 25.7964 13.0921 25.4485 12.5108C25.1005 11.9294 24.6063 11.4472 24.0139 11.111Z"
                                        fill="#FD4917" />
                                </svg>
                            </span>
                            <div class="vedio-over-ani"></div>
                        </a>
                    </div>



                </div>
            </div>
        </div>

    </section>

    <!-- work part end  -->




    <!-- about-us part start  -->

    <section class="about-us  ">
        <div class="container">

            <div class="row align-items-center  ">
                <div class="col-lg-6 p-0 about-us-thumb-bg ">
                    <div class="about-us-thumb">
                        <img src="{{ custom_asset($homepage->testimonial_image, '666x820') }}" alt="thumb">
                    </div>
                </div>
                <div class="col-lg-6 about-slick-btm-slick-bg ">
                    <h2 class="taitel">{{ __('translate.What People are Talking About Us') }}</h2>



                    <div class="about-slick-btm-slick">
                        @foreach ($testimonials as $testimonial)
                            <div class="about-slick-btm-item">


                                    <div class="right">
                                        <span>
                                        <svg width="60" height="60" viewBox="0 0 60 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M55.9702 11.994C53.2589 8.94822 49.9682 7.40381 46.1898 7.40381C42.7939 7.40381 39.9151 8.61307 37.6326 10.9978C35.3647 13.3674 34.2147 16.3105 34.2147 19.7458C34.2147 22.9921 35.3763 25.8849 37.6672 28.3439C39.688 30.5133 42.2336 31.8932 45.2472 32.4556C44.7202 36.4511 41.1881 40.0676 34.7278 43.2188L33.5645 43.7863L38.3341 52.5918L39.4108 52.046C53.0727 45.1209 59.9997 35.334 59.9997 22.957C59.9997 18.687 58.6441 14.9986 55.9702 11.994ZM39.3601 49.2764L36.9704 44.8652C44.1567 41.0997 47.7976 36.5731 47.7976 31.3976V30.2895L46.6966 30.1648C43.7312 29.8292 41.3715 28.6804 39.4828 26.6527C37.6077 24.6397 36.6961 22.3806 36.6961 19.7458C36.6961 16.9323 37.5889 14.6322 39.4252 12.7133C41.2467 10.8101 43.4595 9.8849 46.1899 9.8849C49.2725 9.8849 51.8654 11.1144 54.1167 13.6436C56.4058 16.2156 57.5186 19.262 57.5186 22.9569C57.5186 28.6296 55.9213 33.7509 52.7711 38.1786C49.7653 42.4033 45.257 46.133 39.3601 49.2764Z" fill="white"/>
                                        <path d="M22.3404 11.9887C19.599 8.94659 16.2947 7.40405 12.519 7.40405C9.11988 7.40405 6.25406 8.61554 4.0016 11.0048C1.76848 13.3734 0.636094 16.3143 0.636094 19.746C0.636094 22.9922 1.79766 25.885 4.08832 28.3442C6.10488 30.5089 8.61996 31.8875 11.5775 32.4524C11.0569 36.451 7.55414 40.0693 1.14562 43.221L0 43.7842L4.65094 52.596L5.73832 52.0474C19.4621 45.1226 26.4207 35.3352 26.4207 22.9572C26.4206 18.6838 25.0477 14.9935 22.3404 11.9887ZM5.70223 49.2725L3.3777 44.8681C10.5118 41.1011 14.1267 36.5734 14.1267 31.3977V30.2921L13.0282 30.1653C10.1236 29.8301 7.79297 28.6812 5.90367 26.6528C4.02855 24.64 3.11719 22.3807 3.11719 19.746C3.11719 16.9289 3.99703 14.6263 5.80676 12.7069C7.5968 10.8082 9.79254 9.88515 12.519 9.88515C15.6047 9.88515 18.2146 11.1164 20.497 13.6496C22.8135 16.2202 23.9395 19.2648 23.9395 22.9572C23.9395 28.6289 22.3352 33.7496 19.1708 38.1768C16.152 42.4002 11.6243 46.1294 5.70223 49.2725Z" fill="white"/>
                                        </svg>

                                        </span>

                                        <span class="star-svg">
                                            <svg width="95" height="16" viewBox="0 0 95 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M55.863 5.78722C55.8112 5.62592 55.6753 5.5107 55.5102 5.48436L50.5915 4.77331L48.3781 0.246895C48.3037 0.0954657 48.1516 0 47.9866 0C47.8215 0 47.6695 0.0954657 47.595 0.250187L45.4107 4.78977L40.492 5.53375C40.327 5.56008 40.1911 5.6753 40.1393 5.8366C40.0875 5.99791 40.1329 6.17567 40.2526 6.29089L43.8219 9.80997L42.9967 14.794C42.9676 14.9619 43.0355 15.1297 43.1714 15.2285C43.2459 15.2845 43.3365 15.3141 43.4271 15.3141C43.4983 15.3141 43.5662 15.2976 43.631 15.2614L48.0222 12.8945L52.4264 15.2351C52.4911 15.268 52.559 15.2845 52.627 15.2845C52.8664 15.2845 53.0638 15.0836 53.0638 14.84C53.0638 14.8038 53.0606 14.7709 53.0509 14.738L52.1998 9.78364L55.7465 6.2448C55.8727 6.12629 55.9147 5.94853 55.863 5.78722Z" />
                                                <path
                                                    d="M74.9191 5.78722C74.8673 5.62592 74.7314 5.5107 74.5664 5.48436L69.6477 4.77331L67.4343 0.246895C67.3599 0.0954657 67.2078 0 67.0427 0C66.8777 0 66.7256 0.0954657 66.6512 0.250187L64.4669 4.78977L59.5482 5.53375C59.3832 5.56008 59.2473 5.6753 59.1955 5.8366C59.1437 5.99791 59.189 6.17567 59.3087 6.29089L62.878 9.80997L62.0529 14.794C62.0237 14.9619 62.0917 15.1297 62.2276 15.2285C62.302 15.2845 62.3926 15.3141 62.4832 15.3141C62.5544 15.3141 62.6224 15.2976 62.6871 15.2614L67.0783 12.8945L71.4825 15.2351C71.5472 15.268 71.6152 15.2845 71.6831 15.2845C71.9226 15.2845 72.12 15.0836 72.12 14.84C72.12 14.8038 72.1168 14.7709 72.1071 14.738L71.256 9.78364L74.8026 6.2448C74.9288 6.12629 74.9709 5.94853 74.9191 5.78722Z" />
                                                <path
                                                    d="M94.9782 5.78722C94.9264 5.62592 94.7905 5.5107 94.6255 5.48436L89.7068 4.77331L87.4934 0.246895C87.4189 0.0954657 87.2669 0 87.1018 0C86.9368 0 86.7847 0.0954657 86.7103 0.250187L84.526 4.78977L79.6073 5.53375C79.4422 5.56008 79.3063 5.6753 79.2546 5.8366C79.2028 5.99791 79.2481 6.17567 79.3678 6.29089L82.9371 9.80997L82.1119 14.794C82.0828 14.9619 82.1508 15.1297 82.2867 15.2285C82.3611 15.2845 82.4517 15.3141 82.5423 15.3141C82.6135 15.3141 82.6815 15.2976 82.7462 15.2614L87.1374 12.8945L91.5416 15.2351C91.6063 15.268 91.6743 15.2845 91.7422 15.2845C91.9817 15.2845 92.1791 15.0836 92.1791 14.84C92.1791 14.8038 92.1758 14.7709 92.1661 14.738L91.3151 9.78364L94.8617 6.2448C94.9879 6.12629 95.03 5.94853 94.9782 5.78722Z" />
                                                <path
                                                    d="M35.8039 5.78722C35.7521 5.62592 35.6162 5.5107 35.4512 5.48436L30.5325 4.77331L28.3191 0.246895C28.2446 0.0954657 28.0925 0 27.9275 0C27.7625 0 27.6104 0.0954657 27.5359 0.250187L25.3517 4.78977L20.433 5.53375C20.2679 5.56008 20.132 5.6753 20.0802 5.8366C20.0285 5.99791 20.0738 6.17567 20.1935 6.29089L23.7628 9.80997L22.9376 14.794C22.9085 14.9619 22.9764 15.1297 23.1124 15.2285C23.1868 15.2845 23.2774 15.3141 23.368 15.3141C23.4392 15.3141 23.5071 15.2976 23.5719 15.2614L27.9631 12.8945L32.3673 15.2351C32.432 15.268 32.4999 15.2845 32.5679 15.2845C32.8074 15.2845 33.0048 15.0836 33.0048 14.84C33.0048 14.8038 33.0015 14.7709 32.9918 14.738L32.1408 9.78364L35.6874 6.2448C35.8136 6.12629 35.8557 5.94853 35.8039 5.78722Z" />
                                                <path
                                                    d="M15.7448 5.78722C15.693 5.62592 15.5571 5.5107 15.3921 5.48436L10.4734 4.77331L8.25997 0.246895C8.18555 0.0954657 8.03345 0 7.86842 0C7.70339 0 7.55129 0.0954657 7.47687 0.250187L5.29258 4.78977L0.373883 5.53375C0.208848 5.56008 0.0729369 5.6753 0.0211612 5.8366C-0.0306145 5.99791 0.0146893 6.17567 0.134421 6.29089L3.70371 9.80997L2.87853 14.794C2.84941 14.9619 2.91737 15.1297 3.05328 15.2285C3.12771 15.2845 3.21831 15.3141 3.30892 15.3141C3.38011 15.3141 3.44807 15.2976 3.51279 15.2614L7.90402 12.8945L12.3082 15.2351C12.3729 15.268 12.4409 15.2845 12.5088 15.2845C12.7483 15.2845 12.9457 15.0836 12.9457 14.84C12.9457 14.8038 12.9424 14.7709 12.9327 14.738L12.0817 9.78364L15.6283 6.2448C15.7545 6.12629 15.7966 5.94853 15.7448 5.78722Z" />
                                            </svg>
                                        </span>
                                    </div>

                                <p class="about-slick-dec">{{ $testimonial->comment }}</p>

                                <div class="about-slick-btm-inner">
                                    <div class="left">
                                    <div class="left-df">
                                     <div class="about-slick-top-thumb">
                                        <img src="{{ custom_asset($testimonial->image, '56x56') }}" alt="img">
                                     </div>
                                    </div>

                                    <div class="left-df-m">
                                    <h6>{{ $testimonial->name }}</h6>
                                        <h4>{{ $testimonial->designation }}</h4>
                                    </div>

                                    </div>

                                </div>
                            </div>
                        @endforeach

                    </div>



                </div>
            </div>




        </div>
    </section>


    <!-- about-us part end  -->

    <!-- more-Properties  part start  -->

    <section class=" more-properties  footer-top-pad">
        <div class="container">
            <div class="row more-properties-bg align-items-center" data-aos="fade-up">
                <div class="col-lg-7">
                    <h2 class="more-properties-txt">{{ $homepage->home3_explore_title }}</h2>

                    <a href="{{ route('contact-us') }}" class="main-btn">
                        <div class="btn_m">
                            <div class="btn_c">
                                <div class="btn_t1"> {{ __('translate.Contact Us') }}</div>
                                <div class="btn_t2"> {{ __('translate.Contact Us') }}</div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="col-lg-5">
                    <div class="more-properties-thumb">
                        <img src="{{ custom_asset($homepage->home3_explore_image, '331x260') }}" alt="img">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- more-Properties  part end  -->


</main>
@endsection
