@extends('layout')
@section('title')
    <title>{{ $seo_setting->seo_title }}</title>
    <meta name="title" content="{{ $seo_setting->seo_title }}">
    <meta name="description" content="{!! strip_tags(clean($seo_setting->seo_description)) !!}">
@endsection

@section('body-content')
    <main>


        <!-- banner part start  -->

        <div class="banner-two common-class" style=" background-image: url({{ custom_asset($homepage->home2_intro_bg, '1904x953') }});">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-7">
                        <h3 class="banner-t-top-taitel">{{ $homepage->home2_intro_short_title }}</h3>

                        <h1 class="banner-taitel">{{ $homepage->home2_intro_title }}</h1>

                        <p class="banner-taitel-p">{{ $homepage->home2_intro_des }}</p>

                        <form class="banner-sarch-bar" action="{{ route('listings') }}" id="intro_search_form">
                            <input type="hidden" name="category" value="jobpost">

                            <div class="banner-sarch-bar-item">
                                <div class="banner-sarch-bar-item-inner">
                                    <input type="text" class="form-control" id="search" name="search"
                                        placeholder="{{ __('translate.Search here') }}">
                                </div>
                                <div class="banner-sarch-bar-item-inner">
                                    <select class="form-select select2" name="country">
                                        <option selected value="">
                                            {{ __('translate.Country') }}
                                        </option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="banner-sarch-bar-item-inner">
                                    <div class="f-select">
                                        <select class="form-select select2" name="sub_category_id">
                                            <option selected value="">
                                                {{ __('translate.Category') }}
                                            </option>
                                            @foreach ($jobpost_sub_categories as $sub_category)
                                                <option value="{{ $sub_category->id }}">{{ $sub_category->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                </div>
                                <div class="banner-sarch-bar-item-inner  ">
                                    <a class="main-btn " href="javascript:;" id="intro_form_submit">
                                        <div class="btn_m">
                                            <div class="btn_c">
                                                <div class="btn_t1">{{ __('translate.Find Job') }}</div>
                                                <div class="btn_t2">{{ __('translate.Find Job') }}</div>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>

                        </form>



                    </div>

                    <div class="col-lg-5">
                        <div class="banner-two-thumb">
                            <img src="{{ custom_asset($homepage->home2_intro_image, '751x715') }}" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- banner part end  -->



        <!-- categories part start  -->
        <section class="categories common-class">
            <div class="container">
                <div class="row align-items-end ">
                    <div class="col-lg-6 col-sm-9 ">
                        <h2 class="taitel">{{ __('translate.Most Demanding Categories') }}</h2>
                    </div>

                    <div class="col-lg-6  col-sm-3">
                        <a href="{{ route('listings', ['category' => 'jobpost']) }}"
                            class="features-view-btn">{{ __('translate.View More') }}
                            <span>
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-lg-12">
                        <div
                            class="row row-cols-xl-5 row row-cols-xl-5  row-cols-lg-3  row-cols-1 row-cols-sm-2 g-3 mt-20px">

                            @foreach ($jobpost_sub_categories as $sub_category)
                                <div class="col" data-aos="fade-right" data-aos-delay="50">
                                    <div class="categories-item-box">
                                        <div class="categories-item-icon">
                                            <img src="{{ custom_asset($sub_category->icon, '60x60') }}" alt="img">
                                        </div>

                                        <h3 class="categories-item-txt">{{ $sub_category->name }}</h3>

                                        <h5 class="categories-item-dec">{{ $sub_category->total_listing }}
                                            {{ __('translate.Jobs Available') }}</h5>

                                        <a class="main-btn "
                                            href="{{ route('listings', ['sub_category_id' => $sub_category->id, 'category' => 'jobpost']) }}">
                                            <div class="btn_m">
                                                <div class="btn_c">
                                                    <div class="btn_t1">{{ __('translate.Explore Jobs') }}</div>
                                                    <div class="btn_t2">{{ __('translate.Explore Jobs') }}</div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>


                @if ($home2_ads->status == 'enable')
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="categories-ads">
                                <a target="_blank" href="{{ $home2_ads->link }}"> <img
                                src="{{ custom_asset($home2_ads->image, '1416x157') }}" alt="img"></a>
                            </div>
                        </div>
                    </div>
                @endif




            </div>


        </section>
        <!-- categories part end  -->



        <!-- Features part start  -->


        <section class="features features-two   common-class">
            <div class="container">

                <div class="row align-items-end">
                    <div class="col-lg-6 col-sm-8">
                        <h2 class="taitel">{{ __('translate.Featured Jobs') }}</h2>
                    </div>
                    <div class="col-lg-6 col-sm-4">
                        <a href="{{ route('listings', ['category' => 'jobpost', 'featured' => 'enable']) }}"
                            class="features-view-btn">{{ __('translate.View More') }}
                            <span>
                                <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>

                <div class="row g-3 mt-20px">
                    @foreach ($jobpost_featured_listings as $featured_listing)
                        <div class=" col-xl-6 col-lg-12 col-sm-6 col-md-12" data-aos="fade-up" data-aos-delay="50">
                            <div class="features-two-item">
                                <div class="features-two-inner">
                                    <div class="features-two-img">
                                        <img src="{{ custom_asset($featured_listing->thumb_image, '181x181') }}" alt="img">

                                        <div class="features-two-img-overlay">
                                            @if ($featured_listing->is_urgent == 'enable')
                                                <h6 class="txt">{{ __('translate.Urgent') }}</h6>
                                            @endif

                                            @if ($featured_listing->is_featured == 'enable')
                                                <h6 class="txt two">{{ __('translate.Featured') }}</h6>
                                            @endif
                                        </div>

                                    </div>

                                    <div class="features-two-text-item">
                                        <div class="features-two-text-item-top">
                                            <div class="left">
                                                <h6>
                                                    <span>
                                                        <svg width="11" height="12" viewBox="0 0 11 12"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.9992 3.43685C10.9992 4.03875 11.001 4.64023 10.9984 5.24213C10.9971 5.59801 10.8734 5.90737 10.6216 6.16071C10.253 6.53167 9.88231 6.90005 9.51201 7.26973C8.1817 8.59848 6.8514 9.92723 5.52152 11.2564C5.40297 11.3749 5.27925 11.4852 5.11717 11.5408C4.78523 11.6545 4.47658 11.6071 4.21276 11.3775C3.99593 11.1883 3.79548 10.9798 3.59158 10.7764C2.52854 9.71482 1.46636 8.65191 0.405044 7.58899C0.330468 7.51445 0.257184 7.43733 0.192523 7.35417C-0.0816435 7.00001 -0.0622449 6.5097 0.245976 6.18311C0.471862 5.94356 0.708524 5.71391 0.941737 5.48082C2.27248 4.14991 3.60365 2.81944 4.93439 1.48896C5.11415 1.3093 5.29089 1.12618 5.47453 0.949964C5.70904 0.724627 5.99527 0.60485 6.31815 0.603126C7.545 0.597956 8.77142 0.600972 9.99827 0.600972C10.275 0.600972 10.5255 0.673356 10.7251 0.876718C10.8854 1.04001 10.982 1.23519 10.9885 1.46526C10.9971 1.80004 10.9975 2.13481 10.9992 2.46958C11.001 2.79186 10.9992 3.11414 10.9992 3.43642V3.43685ZM9.16327 3.35757C9.1706 2.86252 8.77271 2.45278 8.28603 2.43555C7.76571 2.41702 7.3355 2.82719 7.33075 3.3468C7.32644 3.83798 7.72562 4.24987 8.21059 4.26926C8.72616 4.28994 9.17318 3.86727 9.16327 3.35757Z" />
                                                        </svg>
                                                    </span>
                                                    {{ $featured_listing?->sub_category?->name }}
                                                </h6>
                                            </div>
                                            <div class="right">
                                                @guest('web')
                                                    <a href="javascript:;" class="before_auth_wishlist">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 16 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M8.61204 1.324L8 1.96329L7.38796 1.324C5.69786 -0.441333 2.95767 -0.441334 1.26757 1.324C-0.422524 3.08933 -0.422525 5.95151 1.26757 7.71684L6.77592 13.4704C7.45196 14.1765 8.54804 14.1765 9.22408 13.4704L14.7324 7.71684C16.4225 5.95151 16.4225 3.08934 14.7324 1.324C13.0423 -0.441333 10.3021 -0.441334 8.61204 1.324Z" />
                                                            </svg>
                                                        </span>
                                                    </a>
                                                @else
                                                    <a href="{{ route('user.add-to-wishlist', $featured_listing->id) }}">
                                                        <span>
                                                            <svg width="24" height="21" viewBox="0 0 16 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M8.61204 1.324L8 1.96329L7.38796 1.324C5.69786 -0.441333 2.95767 -0.441334 1.26757 1.324C-0.422524 3.08933 -0.422525 5.95151 1.26757 7.71684L6.77592 13.4704C7.45196 14.1765 8.54804 14.1765 9.22408 13.4704L14.7324 7.71684C16.4225 5.95151 16.4225 3.08934 14.7324 1.324C13.0423 -0.441333 10.3021 -0.441334 8.61204 1.324Z" />
                                                            </svg>
                                                        </span>
                                                    </a>

                        @endif
                    </div>
                </div>


                <a href="{{ route('listing', $featured_listing->slug) }}">
                    <h3 class="txt-link">{{ html_decode($featured_listing->title) }}</h3>
                </a>

                <div class="btn-box">
                    <a href="javascript:;">
                        <span>
                            <svg width="11" height="11" viewBox="0 0 11 11" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M3.81628 0.513554C3.81628 0.298962 3.64232 0.125 3.42773 0.125C3.21313 0.125 3.03917 0.298962 3.03917 0.513554V1.7167C2.18907 2.14527 1.51277 2.86822 1.14421 3.75163H9.8559C9.48734 2.86823 8.81106 2.14529 7.96097 1.71672V0.513554C7.96097 0.298962 7.78701 0.125 7.57242 0.125C7.35782 0.125 7.18386 0.298962 7.18386 0.513554V1.4222C6.85788 1.33638 6.51563 1.29067 6.1627 1.29067H4.8374C4.48449 1.29067 4.14225 1.33638 3.81628 1.42219V0.513554ZM0.837402 5.29067C0.837402 5.03013 0.862313 4.7754 0.909883 4.52874H10.0902C10.1378 4.7754 10.1627 5.03013 10.1627 5.29068V6.87501C10.1627 9.08415 8.37184 10.875 6.1627 10.875H4.8374C2.62827 10.875 0.837402 9.08415 0.837402 6.87501V5.29067ZM5.50004 7.76653C5.78616 7.76653 6.01811 7.53458 6.01811 7.24846C6.01811 6.96234 5.78616 6.73039 5.50004 6.73039C5.21391 6.73039 4.98196 6.96234 4.98196 7.24846C4.98196 7.53458 5.21391 7.76653 5.50004 7.76653ZM8.09014 7.24846C8.09014 7.53458 7.85819 7.76653 7.57207 7.76653C7.28595 7.76653 7.054 7.53458 7.054 7.24846C7.054 6.96234 7.28595 6.73039 7.57207 6.73039C7.85819 6.73039 8.09014 6.96234 8.09014 7.24846ZM3.42769 7.76653C3.71381 7.76653 3.94576 7.53458 3.94576 7.24846C3.94576 6.96234 3.71381 6.73039 3.42769 6.73039C3.14157 6.73039 2.90962 6.96234 2.90962 7.24846C2.90962 7.53458 3.14157 7.76653 3.42769 7.76653Z" />
                            </svg>
                        </span>

                        {{ $featured_listing->created_at->diffForHumans() }}
                    </a>


                    <a href="javascript:;" class="active">
                        <span>
                            <svg width="10" height="11" viewBox="0 0 10 11" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M4.65385 11C6.39904 11 9.30769 7.58895 9.30769 4.88889C9.30769 2.18883 7.22409 0 4.65385 0C2.0836 0 0 2.18883 0 4.88889C0 7.58895 2.90865 11 4.65385 11ZM4.65371 6.59992C5.51046 6.59992 6.20499 5.86119 6.20499 4.94992C6.20499 4.03865 5.51046 3.29992 4.65371 3.29992C3.79696 3.29992 3.10243 4.03865 3.10243 4.94992C3.10243 5.86119 3.79696 6.59992 4.65371 6.59992Z"
                                    fill="#FD4917" />
                            </svg>
                        </span>

                        {{ html_decode($featured_listing->address) }}
                    </a>
                </div>


                <div class="btn-price">
                    <p class="btn-price-txt">{{ currency($featured_listing->regular_price) }}/{{ __('translate.m') }}</p>
                    <a class="main-btn "
                        href="{{ route('listing', ['slug' => $featured_listing->slug, 'is_apply' => 'yes']) }}">
                        <div class="btn_m">
                            <div class="btn_c">
                                <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                            </div>
                        </div>
                    </a>
                </div>


                </div>

                </div>
                </div>
                </div>
                @endforeach

                </div>


                </div>
            </section>

            <!-- Features part end  -->



            <!-- Locations part start  -->

            <section class="locations common-class">
                <div class="container">
                    <div class="row align-items-end">
                        <div class="col-lg-6 col-sm-6">
                            <h2 class="taitel">{{ __('translate.Browse By Cities') }}</h2>
                        </div>
                        <div class="col-lg-6  col-sm-6">
                            <a href="{{ route('listings', ['category' => 'jobpost']) }}" class="features-view-btn">
                                {{ __('translate.View More') }}
                                <span>
                                    <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </span>
                            </a>
                        </div>
                    </div>

                    <div class="row g-3 mt-20px">
                        @foreach ($cities->take(6) as $city)
                            <div class=" col-xxl-2 col-lg-4 col-sm-6 " data-aos="fade-right" data-aos-delay="50">
                                <div class="locations-item">
                                    <div class="locations-item-thumb">
                                        <img src="{{ custom_asset($city->image, '196x210') }}" alt="img">
                                    </div>

                                    <div class="locations-item-text">
                                        <a
                                            href="{{ route('listings', ['location' => $city->id, 'country' => $city->country_id, 'category' => 'classified']) }}">
                                            <h3>{{ $city->name }}</h3>
                                        </a>

                                        <h5>{{ $city->total_jobpost_listing }}+ {{ __('translate.Listing') }}</h5>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </section>
            <!-- Locations part end  -->

            <!-- _explore-new part start  -->
            <section class="explore-new common-class"
                style=" background-image: url({{ custom_asset($homepage->home2_explore_image, '1904x514') }}) ;">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7">
                            <span class="explore-txt">{{ $homepage->home2_explore_title }}</span>

                            <h2 class="explore-taitel">
                                {{ $homepage->home2_explore_des }}
                            </h2>

                            <a class="main-btn " href="{{ route('contact-us') }}">
                                <div class="btn_m">
                                    <div class="btn_c">
                                        <div class="btn_t1"> {{ __('translate.Contact Us') }}</div>
                                        <div class="btn_t2"> {{ __('translate.Contact Us') }}</div>
                                    </div>
                                </div>
                            </a>
                        </div>

                    </div>
                </div>
            </section>
            <!-- _explore-new part end  -->


            <!-- job-Listing part start  -->

            <section class="job-listing  job_listing_custom_padding">
                <div class="container">
                    <div class="row align-items-end">
                        <div class="col-lg-6 col-sm-8">
                            <h2 class="taitel">{{ __('translate.Browse by New Job Listing') }}</h2>
                        </div>

                        <div class="col-lg-6 col-sm-4">
                            <a href="{{ route('listings', ['category' => 'jobpost']) }}" class="features-view-btn">
                                {{ __('translate.View More') }}
                                <span>
                                    <svg width="14" height="10" viewBox="0 0 14 10" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 9L13 5M13 5L9 1M13 5L1 5" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round"></path>
                                    </svg>
                                </span>
                            </a>
                        </div>
                    </div>


                    <div class="row g-3 mt-20px">
                        @foreach ($jobpost_latest_listings as $latest_listing)
                            <div class="col-xxl-3 col-lg-4 col-sm-6" data-aos="fade-up" data-aos-delay="400">
                                <div class="job-listing-item">
                                    <div class="job-listing-item-inner">
                                        <div class="job-listing-img">
                                            <img src="{{ custom_asset($latest_listing->thumb_image, '128x128') }}" alt="img">
                                        </div>

                                        <div class="job-listing-img-btn">
                                            @guest('web')
                                                <a href="javascript:;" class="before_auth_wishlist">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @else
                                                <a href="{{ route('user.add-to-wishlist', $latest_listing->id) }}">
                                                    <span>
                                                        <svg width="24" height="21" viewBox="0 0 20 18" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M10.765 1.70229L10 2.52422L9.23495 1.70229C7.12233 -0.567428 3.69709 -0.56743 1.58447 1.70229C-0.528155 3.972 -0.528156 7.65194 1.58447 9.92165L8.4699 17.3191C9.31495 18.227 10.685 18.227 11.5301 17.3191L18.4155 9.92165C20.5282 7.65194 20.5282 3.972 18.4155 1.70229C16.3029 -0.567429 12.8777 -0.567429 10.765 1.70229Z" />
                                                        </svg>
                                                    </span>
                                                </a>
                                            @endguest

                                            @if ($latest_listing->is_urgent == 'enable')
                                                <span class="txt">{{ __('translate.Urgent') }}</span>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="job-listing-content">
                                        <p>{{ currency($latest_listing->regular_price) }}/{{ __('translate.m') }}</p>

                                        <a href="{{ route('listing', $latest_listing->slug) }}">
                                            <h3 class="job-listing-content-link">{{ html_decode($latest_listing->title) }}
                                            </h3>
                                        </a>
                                    </div>

                                    <div class="job-listing-content-btn">
                                        <a href="javascript:;">
                                            <span>
                                                <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M2.97888 0.513554C2.97888 0.298962 2.80492 0.125 2.59032 0.125C2.37573 0.125 2.20177 0.298962 2.20177 0.513554V1.7167C1.35167 2.14527 0.675371 2.86822 0.306805 3.75163H9.0185C8.64993 2.86823 7.97365 2.14529 7.12357 1.71672V0.513554C7.12357 0.298962 6.94961 0.125 6.73501 0.125C6.52042 0.125 6.34646 0.298962 6.34646 0.513554V1.4222C6.02048 1.33638 5.67823 1.29067 5.3253 1.29067H4C3.64709 1.29067 3.30485 1.33638 2.97888 1.42219V0.513554ZM0 5.29067C0 5.03013 0.0249108 4.7754 0.0724807 4.52874H9.25282C9.30039 4.7754 9.3253 5.03013 9.3253 5.29068V6.87501C9.3253 9.08415 7.53444 10.875 5.3253 10.875H4C1.79086 10.875 0 9.08415 0 6.87501V5.29067ZM4.66263 7.76653C4.94876 7.76653 5.18071 7.53458 5.18071 7.24846C5.18071 6.96234 4.94876 6.73039 4.66263 6.73039C4.37651 6.73039 4.14456 6.96234 4.14456 7.24846C4.14456 7.53458 4.37651 7.76653 4.66263 7.76653ZM7.25274 7.24846C7.25274 7.53458 7.02079 7.76653 6.73467 7.76653C6.44854 7.76653 6.21659 7.53458 6.21659 7.24846C6.21659 6.96234 6.44854 6.73039 6.73467 6.73039C7.02079 6.73039 7.25274 6.96234 7.25274 7.24846ZM2.59029 7.76653C2.87641 7.76653 3.10836 7.53458 3.10836 7.24846C3.10836 6.96234 2.87641 6.73039 2.59029 6.73039C2.30417 6.73039 2.07222 6.96234 2.07222 7.24846C2.07222 7.53458 2.30417 7.76653 2.59029 7.76653Z" />
                                                </svg>
                                            </span>

                                            {{ $latest_listing->created_at->diffForHumans() }}
                                        </a>


                                        <a href="javascript:;">
                                            <span>
                                                <svg width="12" height="14" viewBox="0 0 10 11" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M4.81644 11C6.56164 11 9.47029 7.58895 9.47029 4.88889C9.47029 2.18883 7.38669 0 4.81644 0C2.2462 0 0.162598 2.18883 0.162598 4.88889C0.162598 7.58895 3.07125 11 4.81644 11ZM4.81631 6.59992C5.67306 6.59992 6.36759 5.86119 6.36759 4.94992C6.36759 4.03865 5.67306 3.29992 4.81631 3.29992C3.95956 3.29992 3.26502 4.03865 3.26502 4.94992C3.26502 5.86119 3.95956 6.59992 4.81631 6.59992Z" />
                                                </svg>
                                            </span>

                                            {{ html_decode($latest_listing->address) }}
                                        </a>
                                    </div>

                                    <div class="job-listing-btn">
                                        <a class="main-btn "
                                            href="{{ route('listing', ['slug' => $latest_listing->slug, 'is_apply' => 'yes']) }}">
                                            <div class="btn_m">
                                                <div class="btn_c">
                                                    <div class="btn_t1">{{ __('translate.Apply Now') }}</div>
                                                    <div class="btn_t2">{{ __('translate.Apply Now') }}</div>
                                                </div>
                                            </div>
                                        </a>
                                        <a class="main-btn two " href="{{ route('listing', $latest_listing->slug) }}">
                                            <div class="btn_m">
                                                <div class="btn_c">
                                                    <div class="btn_t1">{{ __('translate.Detail Now') }}</div>
                                                    <div class="btn_t2">{{ __('translate.Detail Now') }}</div>
                                                </div>
                                            </div>
                                        </a>


                                    </div>
                                </div>
                            </div>
                        @endforeach

                    </div>

                </div>
            </section>

            <!-- job-Listing part end  -->

        </main>
    @endsection
