@extends('layout')
@section('title')
    <title>{{ __('translate.My Listing') }}</title>
@endsection
@section('body-content')

    <main>
        <!-- inner-bg  part start  -->
        <div class="inner-bg common-class"
             style="    background-image:  url({{ custom_asset($breadcrumb, '1905x408') }});">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="inner-bg-txt">
                            <h1>{{ __('translate.My Listing') }}</h1>
                            <ul>
                                <li><a href={{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li>
                                 <span>
                                <svg width=" 6" height="12" viewBox="0 0 6 12" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <title>Arrow Icon</title>
                                    <path
                                        d="M0.634 0C0.447 0.053 0.284 0.143 0.158 0.319C-0.049 0.619 -0.055 1.052 0.155 1.351C0.196 1.408 0.24 1.464 0.286 1.517C1.565 2.975 2.846 4.436 4.125 5.893C4.154 5.926 4.189 5.953 4.242 6.033C4.207 6.056 4.163 6.069 4.134 6.103C2.841 7.573 1.55 9.048 0.257 10.518C0.03 10.778 -0.058 11.077 0.041 11.437C0.187 11.959 0.777 12.172 1.162 11.843C1.206 11.806 1.247 11.763 1.288 11.72C2.776 10.023 4.265 8.329 5.751 6.632C6.022 6.322 6.075 5.93 5.894 5.574C5.85 5.487 5.786 5.411 5.725 5.341C4.28 3.694 2.835 2.05 1.393 0.399C1.232 0.216 1.069 0.053 0.838 0C0.771 0 0.704 0 0.634 0Z"
                                        fill="currentColor"
                                    />
                                    </svg>
                                    </span>
                                </li>
                                <li><a href="javascript:;" class="active">{{ __('translate.My Listing') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- inner-bg  part end  -->

        <!-- dashboard-part-start -->
        <section class="dashboard footer-top-pad">
            <div class="container">
                <div class="row">
                    <!-- Sidebar Section -->
                    @include('profile.sidebar')



                    <div class="col-xxl-9 col-xl-8 col-lg-8">
                        @if($listings->count() > 0 || $products->count() > 0)
                        <div class="row align-items-end">
                            <div class="col-lg-8">
                                <ul class="nav shaf-filter course-filter" id="Classified_item_filter" role="tablist">
                                    <li class="nav-item active" role="presentation" id="listing-tab" data-bs-toggle="pill" href="#listing" role="tab" aria-controls="listing" aria-selected="true">
                                        {{ __('translate.Listing') }}
                                    </li>
                                    <li class="nav-item" role="presentation"  id="product-tab" data-bs-toggle="pill" href="#product" role="tab" aria-controls="product" aria-selected="false">
                                        {{ __('translate.Product') }}
                                    </li>
                                </ul>
                            </div>
                            <div class="tab-content mt-3" id="listingProductTabsContent">
                                <!-- Listing Tab Content -->
                                <div class="tab-pane fade show active" id="listing" role="tabpanel" aria-labelledby="listing-tab">
                                    <!-- Listing Content goes here -->
                                    <div class="row g-3 mt-2">
                                        @forelse ($listings as $index => $listing)
                                            <div class="col-xxl-4 col-lg-6 col-sm-6 aos-init aos-animate">
                                                <div class="features-single-box">
                                                    <div class="features-thumb">
                                                        <img src="{{ custom_asset($listing->thumb_image, '315x230') }}" alt="img">
                                                    </div>
                                                    <div class="features-single-box-over">
                                                        <div class="text">
                                                            @if ($listing->is_urgent == 'enable')
                                                                <p>{{ __('translate.Urgent') }}</p>
                                                            @endif
                                                            @if ($listing->is_featured == 'enable')
                                                                <h6>{{ __('translate.Featured') }}</h6>
                                                            @endif
                                                        </div>
                                                        <div class="icon">
                                                            <a href="javascript:;" onclick="deleteListing({{ $listing->id }}, 'listing')">
                                                                <span>
                                                                    <!-- SVG for delete icon -->
                                                                    <svg width="20" height="20" viewBox="0 0 10 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M3.00263 1.11959C3.00264 1.02425 3.0377 0.932817 3.1001 0.865384C3.1625 0.797951 3.24713 0.760035 3.33539 0.759968L6.66283 0.759766C6.75112 0.759987 6.83572 0.798008 6.8981 0.865495C6.96048 0.932982 6.99554 1.02443 6.9956 1.11979V2.00871H3.00263V1.11959ZM8.47359 13.2051C8.46511 13.3453 8.40734 13.4767 8.31213 13.5723C8.21692 13.668 8.09145 13.7207 7.96142 13.7198H1.99857C1.86857 13.7194 1.74351 13.6659 1.64852 13.57C1.55352 13.4742 1.49562 13.343 1.48643 13.203L0.976179 5.14029H9.01818L8.47371 13.205L8.47359 13.2051ZM9.79922 4.41006H0.199219V3.57473C0.199361 3.35318 0.28089 3.14075 0.425903 2.98408C0.570917 2.82741 0.767562 2.7393 0.972664 2.7391L9.02568 2.73882C9.23076 2.73916 9.42735 2.82735 9.57232 2.98404C9.71729 3.14073 9.79881 3.35313 9.79901 3.57465V4.40999L9.79922 4.41006ZM3.45348 11.7977C3.45348 11.8456 3.46222 11.8931 3.4792 11.9374C3.49619 11.9817 3.52108 12.0219 3.55246 12.0558C3.58385 12.0897 3.62111 12.1166 3.66211 12.135C3.70311 12.1533 3.74706 12.1628 3.79144 12.1628C3.83583 12.1628 3.87977 12.1533 3.92078 12.135C3.96178 12.1166 3.99904 12.0897 4.03042 12.0558C4.06181 12.0219 4.0867 11.9817 4.10369 11.9374C4.12067 11.8931 4.12941 11.8456 4.12941 11.7977V6.67821C4.1287 6.58194 4.0928 6.48986 4.02953 6.42204C3.96627 6.35422 3.88075 6.31614 3.79162 6.31611C3.70248 6.31608 3.61695 6.35409 3.55363 6.42186C3.49032 6.48963 3.45437 6.58168 3.45359 6.67796V11.7977H3.45348ZM5.86485 11.7977C5.86485 11.8945 5.90047 11.9874 5.96386 12.0559C6.02725 12.1244 6.11322 12.1628 6.20287 12.1628C6.29252 12.1628 6.37849 12.1244 6.44188 12.0559C6.50527 11.9874 6.54088 11.8945 6.54088 11.7977V6.67821C6.54017 6.58192 6.50427 6.48983 6.44099 6.422C6.37772 6.35417 6.29219 6.31609 6.20304 6.31606C6.1139 6.31603 6.02835 6.35404 5.96503 6.42182C5.90171 6.48961 5.86574 6.58167 5.86497 6.67796L5.86485 11.7977Z">
                                                                        </path>
                                                                    </svg>
                                                                </span>
                                                            </a>
                                                            <form action="{{ route('user.remove-wishlist', ['id' => $listing->id, 'type' => 'listing']) }}" method="post" class="d-none" id="remove_listing_{{ $listing->id }}">
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <div class="features-single-box-inner">
                                                        <div class="features-single-box-inner-txt">
                                                            <p>
                                                                <span>
                                                                    <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z"/>
                                                                    </svg>
                                                                </span>
                                                                {{ $listing?->subCategory?->name }}
                                                            </p>
                                                            <span>{{ currency($listing->regular_price) }}</span>
                                                        </div>
                                                        <a href="{{ route('listing', $listing->slug) }}">
                                                            <h3>{{ html_decode($listing->title) }}</h3>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty

                                        @endforelse
                                    </div>

                                </div>

                                <!-- Product Tab Content -->
                                <div class="tab-pane fade" id="product" role="tabpanel" aria-labelledby="product-tab">
                                    <!-- Product Content goes here -->
                                    <div class="row g-3 mt-2">
                                        @forelse ($products as $index => $product)
                                            <div class="col-xxl-4 col-lg-6 col-sm-6 aos-init aos-animate">
                                                <div class="features-single-box">
                                                    <div class="features-thumb">
                                                        <img src="{{ custom_asset($product->thumbnail_image, '315x230') }}" alt="img">
                                                    </div>
                                                    <div class="features-single-box-over">
                                                        <div class="icon">
                                                            <a href="javascript:;" onclick="deleteListing({{ $product->id }}, 'product')">
                                                                <span>
                                                                    <!-- Same SVG for delete icon as above -->
                                                                </span>
                                                            </a>
                                                            <form action="{{ route('user.remove-wishlist', ['id' => $product->id, 'type' => 'product']) }}" method="post" class="d-none" id="remove_product_{{ $product->id }}">
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <div class="features-single-box-inner">
                                                        <div class="features-single-box-inner-txt">
                                                            <p>
                                                                <span>
                                                                    <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M5.5 13C7.5625 13 11 8.96876 11 5.77778C11 2.5868 8.53757 0 5.5 0C2.46243 0 0 2.5868 0 5.77778C0 8.96876 3.4375 13 5.5 13ZM5.5 7.7999C6.51252 7.7999 7.33333 6.92686 7.33333 5.8499C7.33333 4.77295 6.51252 3.8999 5.5 3.8999C4.48748 3.8999 3.66667 4.77295 3.66667 5.8499C3.66667 6.92686 4.48748 7.7999 5.5 7.7999Z"/>
                                                                    </svg>
                                                                </span>
                                                                {{ $product?->subCategory?->name }}
                                                            </p>
                                                            <span>{!! $product->price_display !!}</span>
                                                        </div>
                                                        <a href="{{ route('product.view', $product->slug) }}">
                                                            <h3>{{ html_decode($product->translate->name) }}</h3>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @empty
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                </div>
            </div>
        </section>        <!-- dashboard-part-end -->

        @include('profile.logout')
    </main>

@endsection

@push('js_section')

   <script>
        // Wait for the DOM to load
        document.addEventListener('DOMContentLoaded', function() {
            // Get all the filter buttons
            const filterButtons = document.querySelectorAll('.shaf-filter li');

            // Get all the Listing and Product items
            const listingItems = document.querySelectorAll('[data-groups="Listing"]');
            const productItems = document.querySelectorAll('[data-groups="Product"]');

            // Iterate over each filter button
            filterButtons.forEach(button => {
                button.addEventListener('click', function() {
                    // Remove 'active' class from all buttons
                    filterButtons.forEach(btn => btn.classList.remove('active'));

                    // Add 'active' class to the clicked button
                    this.classList.add('active');

                    // Get the data-group of the clicked button
                    const group = this.getAttribute('data-group');

                    // Show the corresponding items based on the selected group
                    if (group === 'Listing') {
                        // Show Listing items and hide Product items
                        listingItems.forEach(item => item.style.display = 'block');
                        productItems.forEach(item => item.style.display = 'none');
                    } else if (group === 'Product') {
                        // Show Product items and hide Listing items
                        productItems.forEach(item => item.style.display = 'block');
                        listingItems.forEach(item => item.style.display = 'none');
                    }
                });
            });

        // Initialize the page with 'Listing' items visible (if needed)
        listingItems.forEach(item => item.style.display = 'block');
        productItems.forEach(item => item.style.display = 'none');
    });
    </script>

    <script src="{{ asset('global/sweetalert/sweetalert2@11.js') }}"></script>

    <script>
        "use strict";

        function deleteListing(id, type) {
            // Set form ID based on item type (product or listing)
            let formId = type === 'product' ? `remove_product_${id}` : `remove_listing_${id}`;

            // Show SweetAlert confirmation dialog
            Swal.fire({
                title: "{{ __('translate.Are you really want to delete this item ?') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{ __('Yes, Delete It') }}",
                cancelButtonText: "{{ __('Cancel') }}",
            }).then((result) => {
                // If user confirmed, submit the form
                if (result.isConfirmed) {
                    document.getElementById(formId).submit();
                }
            });
        }
    </script>

@endpush
